package com.bxm.vision.engine.facade;

import com.bxm.vision.engine.facade.model.RulerBo;
import com.bxm.vision.engine.facade.model.StrategyBo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * zk 服务
 *
 * @Author kk.xie
 * @Date 2019/12/25 16:32
 * @Version 1.0
 **/
@FeignClient("engine-regulation")
public interface ZookeeperFeignClientService {
    /**
     * 初始化 zk节点
     *
     * @param strategyBo
     * @return
     */
    @RequestMapping(value = "/initDotNode", method = RequestMethod.POST)
    boolean initDotNode(@RequestBody StrategyBo strategyBo);
    /**
     * 初始化 detail节点
     *
     * @param strategyBo
     * @return boolean
     * @author kk.xie
     * @date 2020/1/6 17:42
     */
    @RequestMapping(value = "/initDetailNode", method = RequestMethod.POST)
    boolean initDetailNode(@RequestBody StrategyBo strategyBo);

    /**
     * 初始化 merge节点
     *
     * @param strategyBo
     * @return boolean
     * @author kk.xie
     * @date 2020/1/6 17:42
     */
    @RequestMapping(value = "/initMergeNode", method = RequestMethod.POST)
    boolean initMergeNode(@RequestBody StrategyBo strategyBo);

    /**
     * 新增规则任务节点
     *
     * @param rulerBo
     * @return
     */
    @RequestMapping(value = "/addNode", method = RequestMethod.POST)
    boolean addDotOrDetailNode(@RequestBody RulerBo rulerBo);

    /**
     * 更新节点状态-等待
     *
     * @param rulerBo
     * @return
     */
    @RequestMapping(value = "/updateNodeWait", method = RequestMethod.POST)
    boolean updateDotOrDetailNodeWait(@RequestBody RulerBo rulerBo);
    /**
     * 更新节点状态-执行中
     *
     * @param rulerBo
     * @return
     */
    @RequestMapping(value = "/updateNodeExecuting", method = RequestMethod.POST)
    boolean updateDotOrDetailNodeExecuting(@RequestBody RulerBo rulerBo);
    /**
     * 更新节点状态-完成
     *
     * @param rulerBo
     * @return
     */
    @RequestMapping(value = "/updateNodeFinish", method = RequestMethod.POST)
    boolean updateDotOrDetailNodeFinish(@RequestBody RulerBo rulerBo);
    /**
     * 更新节点状态-异常
     *
     * @param rulerBo
     * @return
     */
    @RequestMapping(value = "/updateNodeError", method = RequestMethod.POST)
    boolean updateDotOrDetailNodeError(@RequestBody RulerBo rulerBo);


    /**
     * 新增规则任务节点
     *
     * @param rulerBo
     * @return
     */
    @RequestMapping(value = "/addMergeNode", method = RequestMethod.POST)
    boolean addMergeNode(RulerBo rulerBo);

    /**
     * 更新节点状态-等待
     *
     * @param rulerBo
     * @return
     */
    @RequestMapping(value = "/updateMergeNodeWait", method = RequestMethod.POST)
    boolean updateMergeNodeWait(RulerBo rulerBo);
    /**
     * 更新节点状态-执行中
     *
     * @param rulerBo
     * @return
     */
    @RequestMapping(value = "/updateMergeNodeExecuting", method = RequestMethod.POST)
    boolean updateMergeNodeExecuting(RulerBo rulerBo);
    /**
     * 更新节点状态-完成
     *
     * @param rulerBo
     * @return
     */
    @RequestMapping(value = "/updateMergeNodeFinish", method = RequestMethod.POST)
    boolean updateMergeNodeFinish(RulerBo rulerBo);
    /**
     * 更新节点状态-异常
     *
     * @param rulerBo
     * @return
     */
    @RequestMapping(value = "/updateMergeNodeError", method = RequestMethod.POST)
    boolean updateMergeNodeError(RulerBo rulerBo);
}
