package com.bxm.vision.engine.facade.model;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 任务业务对象
 *
 * @ClassName EngineDto
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/12/26 18:06
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/12/26 18:06
 **/
@Data
public class EngineDto implements Serializable{
    private static final long serialVersionUID = -6715348989044472387L;
    /**
     * 任务号
     */
    private String taskId;
    /**
     * 任务号单次执行唯一编码，uuid
     */
    private String uuid;
    /**
     * 任务名称
     */
    private String name;
    /**
     * 规则组ID--也叫策略ID
     */
    private Long groupId;
    /**
     * 规则组名称--也叫策略名称
     */
    private String groupName;
    /**
     * 策略ID
     */
    private Long strategyId;
    /**
     * 产品类型
     */
    private String productType;
    /**
     * 规则集合
     */
    private RulerDto rulerDto;
}
