package com.bxm.vision.engine.facade.model;

import lombok.Data;

/**
 * 资源对象的基本信息
 *
 * @Author kk.xie
 * @Date 2019/12/20 17:07
 * @Version 1.0
 **/
@Data
public class ResourcesBo {
    private String ip;

    private Integer port;

    private Type type;

    public enum Type{
        /**
         * 获取
         */
        ACQUIRE,
        /**
         * 释放
         */
        RELEASE,
        /**
         * 服务启动时的新增
         */
        ADD
    }

    public static ResourcesBo acquire(){
        ResourcesBo resourcesBo = new ResourcesBo();
        resourcesBo.setType(Type.ACQUIRE);
        return resourcesBo;
    }
    public static ResourcesBo release(ResourcesBo resourcesBo){
        resourcesBo.setType(Type.RELEASE);
        return resourcesBo;
    }
    public static ResourcesBo add(String ip, Integer port){
        ResourcesBo resourcesBo = new ResourcesBo();
        resourcesBo.setIp(ip);
        resourcesBo.setPort(port);
        resourcesBo.setType(Type.ADD);
        return resourcesBo;
    }


}
