package com.bxm.vision.engine.facade.model;

import com.google.common.collect.Lists;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

/**
 * 规则Bo
 *
 * @Author kk.xie
 * @Date 2019/12/20 14:49
 * @Version 1.0
 **/
@Data
public class RulerBo implements Serializable{
    private static final long serialVersionUID = -1136258086724563236L;

    public static final Integer NO = 0;
    public static final Integer YES = 1;

    public static final String WARN_TYPE_CONSOLE = "CONSOLE";
    public static final String WARN_TYPE_DINGDING= "DINGDING";
    public static final String WARN_TYPE_MESSAGE = "MESSAGE";
    public static final String WARN_TYPE_EMAIL = "EMAIL";

    public static final String DIM_UID = "UID";
    public static final String DIM_IP= "IP";
    public static final String DIM_POSITION = "POSITION";
    public static final String DIM_DEVICE = "DEVICE";
    public static final String DIM_BRAND = "BRAND";

    public static final String EXE_TYPE_DETAIL = "DETAIL";
    public static final String EXE_TYPE_STATISTICS = "STATISTICS";
    public static final String EXE_TYPE_REAL_TIME_DETAIL = "REAL_TIME_DETAIL";
    public static final String EXE_TYPE_REAL_TIME_STATISTICS = "REAL_TIME_STATISTICS";

    /**
     * 规则配置
     */
    private RulerConfig rulerConfig;
    /**
     * 执行的服务配置
     */
    private ResourcesBo resourcesBo;
    /**
     * 分页条数
     */
    private Integer limitSkip;
    /**
     * 分页数量
     */
    private Integer limitSize;
    /**
     * 任务的执行号  uuid
     */
    private String uuid;
    /**
     * 当前执行的流程
     */
    private FlowEnum flowEnum;
    /**
     * 打分类型，暂时写死 todo
     */
    private GradeEnum gradeType = GradeEnum.CONSUME;
    /**
     * 执行的周期
     */
    private String cron;

    public boolean haveWarnTypeConsole(){
        return rulerConfig.getWarnType().contains(WARN_TYPE_CONSOLE);
    }

    public boolean haveWarnTypeDingDing(){
        return rulerConfig.getWarnType().contains(WARN_TYPE_DINGDING);
    }

    public boolean haveWarnTypeMessage(){
        return rulerConfig.getWarnType().contains(WARN_TYPE_MESSAGE);
    }

    public boolean haveWarnTypeEmail(){
        return rulerConfig.getWarnType().contains(WARN_TYPE_EMAIL);
    }

    public boolean bannedIpAble(){
        return YES.equals(rulerConfig.getBannedIp()) ? true : false;
    }

    public boolean bannedUidAble(){
        return YES.equals(rulerConfig.getBannedUid()) ? true : false;
    }

    public boolean aliJoinAble(){
        return YES.equals(rulerConfig.getAliJoin()) ? true : false;
    }

    public String getComputeCollection(){
        // 此方法仅在左右去mongo中查询并返回维度数据时方可调用(com.bxm.vision.engine.executor.service.impl.ComputeServiceImpl.executeDot)，
        // 其他时候调用可能会出现异常
        if(Objects.nonNull(rulerConfig)){
            List<FieldConfig> fieldConfigList = rulerConfig.getFieldConfigList();
            if(CollectionUtils.isNotEmpty(fieldConfigList)){
                return fieldConfigList.get(0).getCollection();
            }
        }
        return null;
    }

    @Data
    public static class RulerConfig implements Serializable {
        private static final long serialVersionUID = -4831296656011698005L;
        /**
         * 策略ID
         */
        private Long strategyId;
        /**
         * 策略名称
         */
        private String strategyName;
        /**
         * 策略编码
         */
        private String strategyCode;
        /**
         * 封禁IP,0-否 1-是
         */
        private Integer bannedIp;
        /**
         * 封禁UID,0-否 1-是
         */
        private Integer bannedUid;
        /**
         * 阿里云风控接入,0-否 1-是
         */
        private Integer aliJoin;
        /**
         * 告警方式，CONSOLE-控制台告警，DINGDING-钉钉告警，MESSAGE-短信告警，EMAIL-邮件告警
         */
        private List<String> warnType;
        /**
         * 当前的执行方式
         */
        private String currentExeType;
        /**
         * 是否预跑
         */
        private Boolean exeTest;

        /**
         * 规则ID
         */
        private Long id;
        /**
         * 规则名称
         */
        private String name;
        /**
         * 规则编码
         */
        private String code;
        /**
         * 规则维度
         */
        private DimEnum dim;
        /**
         * 数据分析脚本
         */
        private String analyzeScript;
        /**
         * 脚本语言，ADS，MYSQL，HADOOP，MONGODB，ELASTICSEARCH 目前写死，未来可根据需要扩展 todo
         */
        private ScriptLanguageEnum scriptLanguage = ScriptLanguageEnum.ADS;
        /**
         * 规则下字段配置集合
         */
        private List<FieldConfig> fieldConfigList;

        public List<String> getDimMongoField(){
            if(DimEnum.UID.equals(dim)){
                return Lists.newArrayList("uid");
            }else if(DimEnum.IP.equals(dim)){
                return Lists.newArrayList("ip");
            }else if(DimEnum.POSITION.equals(dim)){
                return Lists.newArrayList("position_id");
            }else if(DimEnum.DEVICE.equals(dim)){
                return Lists.newArrayList("device_id");
            }else if(DimEnum.BRAND.equals(dim)){
                return Lists.newArrayList("position_id", "brand", "os_type");
            }else{
                return null;
            }
        }
    }

    @Data
    public static class FieldConfig implements Serializable {
        private static final long serialVersionUID = 7366325951940314885L;
        private Long id;
        /**
         * 维度
         */
        private String dim;
        /**
         * 编码
         */
        private String code;
        /**
         * 数据表，字段所属表
         */
        private String collection;
        /**
         * 阈值配置信息
         */
        List<FieldRange> fieldRangeList;
    }

    @Data
    public static class FieldRange implements Serializable {
        private static final long serialVersionUID = -8483807643678705871L;
        /**
         * 阈值最小值
         */
        private Integer min;

        /**
         * 阈值最大值
         */
        private Integer max;
    }
}
