package com.bxm.vision.engine.facade.model;

import java.io.Serializable;

/**
 * 规则业务对象
 *
 * @ClassName RulerDto
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/12/26 18:08
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/12/26 18:08
 **/
public class RulerDto implements Serializable{
    private static final long serialVersionUID = 797905562319042303L;

    /**
     * 规则ID
     */
    private Long id;
    /**
     * 规则名称
     */
    private String name;
    /**
     * 规则编码
     */
    private String code;
    /**
     * 规则类型，DETAIL-明细，STATISTICS-统计
     */
    private String rulerType;
    /**
     * 规则脚本
     */
    private String rulerScript;
    /**
     * 脚本语言，ADS，MYSQL，HADOOP，MONGODB，ELASTICSEARCH
     */
    private ScriptLanguageEnum scriptLanguage;
    /**
     * 数据分析字段，通常为规则脚本的查询结果，打分结果，对错结果同意定义为：result
     */
    private String analyzeField;
    /**
     * 告警类型，CONSOLE-控制台告警，DINGDING-钉钉告警，MESSAGE-短信告警，EMAIL-邮件告警，支持多种，使用','分割，默认DINGDING
     */
    private String warnTypes;
    /**
     * 规则执行周期
     */
    private String rulerCron;
    /**
     * 业务标记，id,code；例如：查询id,name,code ，取id,code作为业务分析维度标记
     */
    private String businessSign;
    /**
     * 打分方式
     */
    private GradeEnum gradeType;
    /**
     * 次数打分方式，允许最大值
     */
    private Integer maxValue;

    /**
     * 规则状态 0-下线 1-上线，默认值1
     */
    private Integer status;
    /**
     * 实时封禁IP 0-否 1-是 默认 0
     */
    private Integer bannedIp;
    /**
     * 实时封禁UID 0-否 1-是 默认 0
     */
    private Integer bannedUid;
    /**
     * 启用阿里云风控SDK 0-否 1-是 默认 0
     */
    private Integer aliyunSafeSdk;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getRulerType() {
        return rulerType;
    }

    public void setRulerType(String rulerType) {
        this.rulerType = rulerType;
    }

    public String getRulerScript() {
        return rulerScript;
    }

    public void setRulerScript(String rulerScript) {
        this.rulerScript = rulerScript;
    }

    public ScriptLanguageEnum getScriptLanguage() {
        return scriptLanguage;
    }

    public void setScriptLanguage(ScriptLanguageEnum scriptLanguage) {
        this.scriptLanguage = scriptLanguage;
    }

    public String getAnalyzeField() {
        return analyzeField;
    }

    public void setAnalyzeField(String analyzeField) {
        this.analyzeField = analyzeField;
    }

    public String getWarnTypes() {
        return warnTypes;
    }

    public void setWarnTypes(String warnTypes) {
        this.warnTypes = warnTypes;
    }

    public String getRulerCron() {
        return rulerCron;
    }

    public void setRulerCron(String rulerCron) {
        this.rulerCron = rulerCron;
    }

    public String getBusinessSign() {
        return businessSign;
    }

    public void setBusinessSign(String businessSign) {
        this.businessSign = businessSign;
    }

    public GradeEnum getGradeType() {
        return gradeType;
    }

    public void setGradeType(GradeEnum gradeType) {
        this.gradeType = gradeType;
    }

    public Integer getMaxValue() {
        return maxValue;
    }

    public void setMaxValue(Integer maxValue) {
        this.maxValue = maxValue;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getBannedIp() {
        return bannedIp;
    }

    public void setBannedIp(Integer bannedIp) {
        this.bannedIp = bannedIp;
    }

    public Integer getAliyunSafeSdk() {
        return aliyunSafeSdk;
    }

    public void setAliyunSafeSdk(Integer aliyunSafeSdk) {
        this.aliyunSafeSdk = aliyunSafeSdk;
    }

    public Integer getBannedUid() {
        return bannedUid;
    }

    public void setBannedUid(Integer bannedUid) {
        this.bannedUid = bannedUid;
    }

    @Override
    public String toString() {
        return "RulerDto{" +
                "id=" + id +
                ", name='" + name + '\'' +
                ", code='" + code + '\'' +
                ", rulerType='" + rulerType + '\'' +
                ", rulerScript='" + rulerScript + '\'' +
                ", scriptLanguage=" + scriptLanguage +
                ", analyzeField='" + analyzeField + '\'' +
                ", warnTypes='" + warnTypes + '\'' +
                ", rulerCron='" + rulerCron + '\'' +
                ", businessSign='" + businessSign + '\'' +
                ", gradeType=" + gradeType +
                ", maxValue=" + maxValue +
                ", status=" + status +
                ", bannedIp=" + bannedIp +
                ", bannedUid=" + bannedUid +
                ", aliyunSafeSdk=" + aliyunSafeSdk +
                '}';
    }
}
