package com.bxm.vision.manager.integration.schedule;

import com.bxm.vision.engine.facade.model.JobDto;

/**
 * 调度对外服务
 *
 * @Author kk.xie
 * @Date 2019/2/14 14:12
 * @Version 1.0
 **/
public interface ScheduleIntegrationService {
    /**
     * 启动任务
     *
     * @param jobDto
     * @return boolean
     * @throws
     * @author kk.xie
     * @date 2019/2/14 14:19
     */
    boolean start(JobDto jobDto);

    /**
     * 重启任务
     *
     * @param jobDto
     * @return boolean
     * @throws
     * @author kk.xie
     * @date 2019/2/14 14:19
     */
    boolean reStart(JobDto jobDto);

    /**
     * 停止任务
     *
     * @param jobDto
     * @return boolean
     * @throws
     * @author kk.xie
     * @date 2019/2/14 14:19
     */
    boolean stop(JobDto jobDto);
}
