package com.bxm.vision.manager.integration.schedule.impl;

import com.bxm.vision.engine.facade.JobFeignClientService;
import com.bxm.vision.engine.facade.model.JobDto;
import com.bxm.vision.manager.common.exception.EngineManagerException;
import com.bxm.vision.manager.integration.schedule.ScheduleIntegrationService;
import com.bxm.warcar.utils.response.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 定时调度服务引用
 *
 * @Author kk.xie
 * @Date 2019/2/14 14:13
 * @Version 1.0
 **/
@Service
public class ScheduleIntegrationServiceImpl implements ScheduleIntegrationService {

    @Autowired
    private JobFeignClientService jobFeignClientService;

    @Override
    public boolean start(JobDto jobDto) {
        ResponseModel<Boolean> responseModel = jobFeignClientService.startTask(jobDto);
        if(responseModel.isSuccess()){
            return true;
        }else{
            throw new EngineManagerException(responseModel.getMessage());
        }
    }

    @Override
    public boolean reStart(JobDto jobDto) {
        ResponseModel<Boolean> responseModel = jobFeignClientService.restartTask(jobDto);
        if(responseModel.isSuccess()){
            return true;
        }else{
            throw new EngineManagerException(responseModel.getMessage());
        }
    }

    @Override
    public boolean stop(JobDto jobDto) {
        ResponseModel<Boolean> responseModel = jobFeignClientService.stopTask(jobDto);
        if(responseModel.isSuccess()){
            return true;
        }else{
            throw new EngineManagerException(responseModel.getMessage());
        }
    }
}
