package com.bxm.vision.manager.model.base;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 分页基础参数对象
 *
 * @Author kk.xie
 * @Date 2019/1/24 13:59
 * @Version 1.0
 **/
public class BaseDto implements Serializable{
    private static final long serialVersionUID = -1344455642746243631L;

    /**
     * 页码
     */
    @ApiModelProperty("页码，默认1")
    private Integer pageNum = 1;

    /**
     * 分页长度
     */
    @ApiModelProperty("分页长度，默认10")
    private Integer pageSize = 10;

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }


    @Override
    public String toString() {
        return "BaseDto{" +
                "pageNum=" + pageNum +
                ", pageSize=" + pageSize +
                '}';
    }
}
