package com.bxm.vision.manager.model.dao;

import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 规则表
 * </p>
 *
 * @author kk.xie
 * @since 2019-01-24
 */
@TableName("tbl_ruler")
public class Ruler implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     * 规则名称
     */
    @ApiModelProperty("规则名称")
    private String name;
    /**
     * 规则执行脚本
     */
    @ApiModelProperty("规则执行脚本")
    private String rulerScript;
    /**
     * 脚本语言，ADS，MYSQL，HADOOP，MONGODB，ELASTICSEARCH
     */
    @ApiModelProperty("脚本语言，ADS，MYSQL，HADOOP，MONGODB，ELASTICSEARCH")
    private String scriptLanguage;
    /**
     * 告警类型，CONSOLE-控制台告警，DINGDING-钉钉告警，MESSAGE-短信告警，EMAIL-邮件告警，支持多种，使用','分割，默认DINGDING
     */
    @ApiModelProperty("告警类型，CONSOLE-控制台告警，DINGDING-钉钉告警，MESSAGE-短信告警，EMAIL-邮件告警，支持多种，使用','分割，默认DINGDING")
    private String warnTypes;
    /**
     * 数据分析字段，通常为规则脚本的查询结果，打分结果，对错结果同意定义为：result
     */
    @ApiModelProperty("数据分析字段，通常为规则脚本的查询结果，打分结果，对错结果同意定义为：result")
    private String analyzeField;
    /**
     *  规则执行周期
     */
    @ApiModelProperty("规则执行周期")
    private String rulerCron;
    /**
     * 业务标记，id,code；例如：查询id,name,code ，取id,code作为业务分析维度标记
     */
    @ApiModelProperty("业务标记，id,code；例如：查询id,name,code ，取id,code作为业务分析维度标记")
    private String businessSign;
    /**
     * 是否模板: 0-否，1-是,默认0非模板
     */
    @ApiModelProperty("是否模板: 0-否，1-是,默认0非模板")
    private Integer template;
    /**
     * 打分类型，LADDER-阶梯型(针对频率类型的规则)，分值为线性关系，满分100分，TRUE_OR_FALSE-对错型(针对只有对错的规则)，100或0两种分值
     */
    @ApiModelProperty("打分类型，LADDER-阶梯型(针对频率类型的规则)，分值为线性关系，满分100分，TRUE_OR_FALSE-对错型(针对只有对错的规则)，100或0两种分值")
    private String gradeType;
    /**
     * 告警上限阈值,超过这个值，直接给出告警，每一条打分规则为100分，根据max_value与规则计算接口进行比例换算得出当前评分
     */
    @ApiModelProperty("告警上限阈值,超过这个值，直接给出告警，每一条打分规则为100分，根据max_value与规则计算接口进行比例换算得出当前评分")
    private Integer maxValue;
    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private Date createTime;
    /**
     * 创建人
     */
    @ApiModelProperty("创建人")
    private String creator;
    /**
     * 修改时间
     */
    @ApiModelProperty("过滤规则名称")
    private Date modifyTime;
    /**
     * 修改人
     */
    @ApiModelProperty("修改人")
    private String modifier;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRulerScript() {
        return rulerScript;
    }

    public void setRulerScript(String rulerScript) {
        this.rulerScript = rulerScript;
    }

    public String getScriptLanguage() {
        return scriptLanguage;
    }

    public void setScriptLanguage(String scriptLanguage) {
        this.scriptLanguage = scriptLanguage;
    }

    public String getWarnTypes() {
        return warnTypes;
    }

    public void setWarnTypes(String warnTypes) {
        this.warnTypes = warnTypes;
    }

    public String getAnalyzeField() {
        return analyzeField;
    }

    public void setAnalyzeField(String analyzeField) {
        this.analyzeField = analyzeField;
    }

    public String getRulerCron() {
        return rulerCron;
    }

    public void setRulerCron(String rulerCron) {
        this.rulerCron = rulerCron;
    }

    public String getBusinessSign() {
        return businessSign;
    }

    public void setBusinessSign(String businessSign) {
        this.businessSign = businessSign;
    }

    public Integer getTemplate() {
        return template;
    }

    public void setTemplate(Integer template) {
        this.template = template;
    }

    public String getGradeType() {
        return gradeType;
    }

    public void setGradeType(String gradeType) {
        this.gradeType = gradeType;
    }

    public Integer getMaxValue() {
        return maxValue;
    }

    public void setMaxValue(Integer maxValue) {
        this.maxValue = maxValue;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getCreator() {
        return creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public String getModifier() {
        return modifier;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    @Override
    public String toString() {
        return "RulerVo{" +
        "id=" + id +
        ", name=" + name +
        ", rulerScript=" + rulerScript +
        ", scriptLanguage=" + scriptLanguage +
        ", warnTypes=" + warnTypes +
        ", analyzeField=" + analyzeField +
        ", rulerCron=" + rulerCron +
        ", businessSign=" + businessSign +
        ", template=" + template +
        ", gradeType=" + gradeType +
        ", maxValue=" + maxValue +
        ", createTime=" + createTime +
        ", creator=" + creator +
        ", modifyTime=" + modifyTime +
        ", modifier=" + modifier +
        "}";
    }
}
