package com.bxm.vision.manager.model.dao;

import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 监控执行日志表
 * </p>
 *
 * @author kk.xie
 * @since 2019-01-24
 */
@TableName("tbl_task_exe_log")
public class TaskExeLog implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     * 监控任务id 
     */
    @ApiModelProperty("监控任务id")
    private String taskId;
    /**
     * 任务单次执行的编码
     */
    @ApiModelProperty("任务单次执行的编码")
    private String uuid;
    /**
     * 监控url地址
     */
    @ApiModelProperty("监控url地址")
    private String monitorUrl;
    /**
     * 业务标记，id,code；例如：查询id,name,code ，取id,code作为业务分析维度标记
     */
    @ApiModelProperty("业务标记，id,code；例如：查询id,name,code ，取id,code作为业务分析维度标记")
    private String businessSign;
    /**
     * 产品类型
     */
    @ApiModelProperty("产品类型")
    private String productType;
    /**
     * 规则ID
     */
    @ApiModelProperty("规则ID")
    private Long rulerId;
    /**
     * 规则名称
     */
    @ApiModelProperty("规则名称")
    private String rulerName;
    /**
     * 任务规则执行的结果，成功/失败
     */
    @ApiModelProperty("任务规则执行的结果")
    private String executeResult;
    /**
     * 执行失败时的错误信息
     */
    @ApiModelProperty("执行失败时的错误信息")
    private String errorMessage;
    /**
     * 规则执行耗时，单位毫秒
     */
    @ApiModelProperty("规则执行耗时，单位毫秒")
    private Integer timeConsume;
    /**
     * 规则执行脚本，占位符遵循mysql规则,例如： where id = ? and name = ? 
     */
    @ApiModelProperty("规则执行脚本")
    private String rulerScript;
    /**
     * 数据分析字段，通常为规则脚本的查询结果，打分结果，对错结果同意定义为：result
     */
    @ApiModelProperty("数据分析字段，通常为规则脚本的查询结果，打分结果，对错结果同意定义为：result")
    private String analyzeField;
    /**
     *  规则执行周期
     */
    @ApiModelProperty("规则执行周期")
    private String rulerCron;
    /**
     * 打分类型，LADDER-阶梯型(针对频率类型的规则)，分值为线性关系，满分100分，TRUE_OR_FALSE-对错型(针对只有对错的规则)，100或0两种分值
     */
    @ApiModelProperty("打分类型，LADDER-阶梯型(针对频率类型的规则)，分值为线性关系，满分100分，TRUE_OR_FALSE-对错型(针对只有对错的规则)，100或0两种分值")
    private String gradeType;
    /**
     * 告警上限阈值,超过这个值，直接给出告警，每一条打分规则为100分，根据max_value与规则计算接口进行比例换算得出当前评分
     */
    @ApiModelProperty("告警上限阈值,超过这个值，直接给出告警，每一条打分规则为100分，根据max_value与规则计算接口进行比例换算得出当前评分")
    private Integer maxValue;
    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private Date createTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTaskId() {
        return taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getUuid() {
        return uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getMonitorUrl() {
        return monitorUrl;
    }

    public void setMonitorUrl(String monitorUrl) {
        this.monitorUrl = monitorUrl;
    }

    public String getBusinessSign() {
        return businessSign;
    }

    public void setBusinessSign(String businessSign) {
        this.businessSign = businessSign;
    }

    public String getProductType() {
        return productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }

    public Long getRulerId() {
        return rulerId;
    }

    public void setRulerId(Long rulerId) {
        this.rulerId = rulerId;
    }

    public String getRulerName() {
        return rulerName;
    }

    public void setRulerName(String rulerName) {
        this.rulerName = rulerName;
    }

    public String getExecuteResult() {
        return executeResult;
    }

    public void setExecuteResult(String executeResult) {
        this.executeResult = executeResult;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Integer getTimeConsume() {
        return timeConsume;
    }

    public void setTimeConsume(Integer timeConsume) {
        this.timeConsume = timeConsume;
    }

    public String getRulerScript() {
        return rulerScript;
    }

    public void setRulerScript(String rulerScript) {
        this.rulerScript = rulerScript;
    }

    public String getAnalyzeField() {
        return analyzeField;
    }

    public void setAnalyzeField(String analyzeField) {
        this.analyzeField = analyzeField;
    }

    public String getRulerCron() {
        return rulerCron;
    }

    public void setRulerCron(String rulerCron) {
        this.rulerCron = rulerCron;
    }

    public String getGradeType() {
        return gradeType;
    }

    public void setGradeType(String gradeType) {
        this.gradeType = gradeType;
    }

    public Integer getMaxValue() {
        return maxValue;
    }

    public void setMaxValue(Integer maxValue) {
        this.maxValue = maxValue;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public String toString() {
        return "TaskExeLogVo{" +
        "id=" + id +
        ", taskId=" + taskId +
        ", uuid=" + uuid +
        ", monitorUrl=" + monitorUrl +
        ", businessSign=" + businessSign +
        ", productType=" + productType +
        ", rulerId=" + rulerId +
        ", rulerName=" + rulerName +
        ", executeResult=" + executeResult +
        ", errorMessage=" + errorMessage +
        ", timeConsume=" + timeConsume +
        ", rulerScript=" + rulerScript +
        ", analyzeField=" + analyzeField +
        ", rulerCron=" + rulerCron +
        ", gradeType=" + gradeType +
        ", maxValue=" + maxValue +
        ", createTime=" + createTime +
        "}";
    }
}
