package com.bxm.vision.manager.model.dto;

import com.bxm.vision.manager.model.base.BaseDto;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 业务标识黑白名单表
 * </p>
 *
 * @author kk.xie
 * @since 2019-01-24
 */
public class FilterConfigDto extends BaseDto implements Serializable {
    private static final long serialVersionUID = -8780673268764105502L;
    @ApiModelProperty("id")
    private Long id;
    /**
     * 过滤规则名称
     */
    @ApiModelProperty("过滤规则名称")
    private String name;
    /**
     * 过滤类型：IP-IP过滤规则，BUSINESS-业务过滤规则
     */
    @ApiModelProperty("过滤类型：IP-IP过滤规则，BUSINESS-业务过滤规则")
    private String filterType;
    /**
     * 白名单或黑名单，WHITE-白名单,BLACK-黑名单
     */
    @ApiModelProperty("白名单或黑名单，WHITE-白名单,BLACK-黑名单")
    private String blackWhiteType;
    /**
     * 是否公共，0-否，1-是，公共的过滤规则将会被应用到所有的规则上，私有的规则与tbl_filter_ruler表配合使用，tbl_ruler规则绑定过滤规则则仅使用绑定的规则。
     */
    @ApiModelProperty("是否公共，0-否，1-是，公共的过滤规则将会被应用到所有的规则上，私有的规则与tbl_filter_ruler表配合使用，tbl_ruler规则绑定过滤规则则仅使用绑定的规则。")
    private Integer publicType;
    /**
     * 是否可用，0-否，1-是
     */
    @ApiModelProperty("是否可用，0-否，1-是")
    private Integer status;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFilterType() {
        return filterType;
    }

    public void setFilterType(String filterType) {
        this.filterType = filterType;
    }

    public String getBlackWhiteType() {
        return blackWhiteType;
    }

    public void setBlackWhiteType(String blackWhiteType) {
        this.blackWhiteType = blackWhiteType;
    }

    public Integer getPublicType() {
        return publicType;
    }

    public void setPublicType(Integer publicType) {
        this.publicType = publicType;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @Override
    public String toString() {
        return "FilterConfigDto{" +
                "id=" + id +
                ", name='" + name + '\'' +
                ", filterType='" + filterType + '\'' +
                ", blackWhiteType='" + blackWhiteType + '\'' +
                ", publicType=" + publicType +
                ", status=" + status +
                '}';
    }
}
