package com.bxm.vision.manager.model.dto;

import com.bxm.vision.manager.model.base.BaseDto;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 监控任务表
 * </p>
 *
 * @author kk.xie
 * @since 2019-01-24
 */
public class TaskDto extends BaseDto implements Serializable {

    private static final long serialVersionUID = 1L;
    @ApiModelProperty("id")
    private Long id;
    /**
     * 监控事件名称 
     */
    @ApiModelProperty("监控事件名称")
    private String name;
    /**
     * 规则组id
     */
    @ApiModelProperty("规则组id")
    private Long groupId;
    /**
     * 监控url地址
     */
    @ApiModelProperty("监控url地址")
    private String monitorUrl;
    /**
     * 产品类型
     */
    @ApiModelProperty("产品类型")
    private String productType;
    /**
     * 监控任务id
     */
    @ApiModelProperty("监控任务id")
    private String taskId;
    /**
     * 任务执行状态，0-未执行，1-执行中
     */
    @ApiModelProperty("任务执行状态，0-未执行，1-执行中")
    private Integer taskStatus;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public String getMonitorUrl() {
        return monitorUrl;
    }

    public void setMonitorUrl(String monitorUrl) {
        this.monitorUrl = monitorUrl;
    }

    public String getProductType() {
        return productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }

    public String getTaskId() {
        return taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public Integer getTaskStatus() {
        return taskStatus;
    }

    public void setTaskStatus(Integer taskStatus) {
        this.taskStatus = taskStatus;
    }


    @Override
    public String toString() {
        return "TaskVo{" +
        "id=" + id +
        ", name=" + name +
        ", groupId=" + groupId +
        ", monitorUrl=" + monitorUrl +
        ", productType=" + productType +
        ", taskId=" + taskId +
        ", taskStatus=" + taskStatus +
        "}";
    }
}
