package com.bxm.vision.manager.model.dto;

import com.bxm.vision.manager.model.base.BaseDto;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 监控执行日志表
 * </p>
 *
 * @author kk.xie
 * @since 2019-01-24
 */
public class TaskExeLogDto extends BaseDto implements Serializable {

    private static final long serialVersionUID = 1L;
    @ApiModelProperty("id")
    private Long id;
    /**
     * 监控任务id 
     */
    @ApiModelProperty("监控任务id")
    private String taskId;
    /**
     * 任务单次执行的编码
     */
    @ApiModelProperty("任务单次执行的编码")
    private String uuid;
    /**
     * 监控url地址
     */
    @ApiModelProperty("监控url地址")
    private String monitorUrl;
    /**
     * 产品类型
     */
    @ApiModelProperty("产品类型")
    private String productType;
    /**
     * 规则ID
     */
    @ApiModelProperty("规则ID")
    private Long rulerId;
    /**
     * 规则名称
     */
    @ApiModelProperty("规则名称")
    private String rulerName;
    /**
     * 任务规则执行的结果，成功/失败
     */
    @ApiModelProperty("任务规则执行的结果")
    private String executeResult;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTaskId() {
        return taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getUuid() {
        return uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getMonitorUrl() {
        return monitorUrl;
    }

    public void setMonitorUrl(String monitorUrl) {
        this.monitorUrl = monitorUrl;
    }

    public String getProductType() {
        return productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }

    public Long getRulerId() {
        return rulerId;
    }

    public void setRulerId(Long rulerId) {
        this.rulerId = rulerId;
    }

    public String getRulerName() {
        return rulerName;
    }

    public void setRulerName(String rulerName) {
        this.rulerName = rulerName;
    }

    public String getExecuteResult() {
        return executeResult;
    }

    public void setExecuteResult(String executeResult) {
        this.executeResult = executeResult;
    }

    @Override
    public String toString() {
        return "TaskExeLogVo{" +
        "id=" + id +
        ", taskId=" + taskId +
        ", uuid=" + uuid +
        ", monitorUrl=" + monitorUrl +
        ", productType=" + productType +
        ", rulerId=" + rulerId +
        ", rulerName=" + rulerName +
        ", executeResult=" + executeResult +
        "}";
    }
}
