package com.bxm.warcar.algorithm.flow.service;

import com.bxm.warcar.algorithm.NumericalModel;
import com.bxm.warcar.algorithm.RequestModel;
import com.bxm.warcar.algorithm.config.Constant;
import com.bxm.warcar.algorithm.flow.FilterInvocation;
import com.bxm.warcar.algorithm.flow.FlowFilterChain;
import com.bxm.warcar.utils.ListOrderHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.LinkedHashMap;
import java.util.Map;


/**
 * <h3>Shenjue.java基本描述</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2019/04/15 19:55
 */
@Service
public class FlowAlgorithmServiceImpl implements FlowAlgorithmService<NumericalModel> {

	@Autowired
	private FlowFilterChain flowFilterChain;

	@Override
	public RequestModel deServie(RequestModel<NumericalModel> requestModel) {
		flowFilterChain.intercept(new FilterInvocation(requestModel));
		sort(requestModel);
		return requestModel;
	}

	private void sort(RequestModel<NumericalModel> requestModel){
		ListOrderHelper.sortList(requestModel.getList(), Constant.FLOWRATE,Constant.DESC);
		Map<String,Double> map = new LinkedHashMap<String,Double>(requestModel.getList().size());
		for(NumericalModel model:requestModel.getList()){
			map.put(model.getId(),model.getFlowRate());
		}
		requestModel.setMap(map);
	}

}
