package com.bxm.warcar.algorithm.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * <h3>Shenjue.java基本描述</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2019/04/16 15:36
 */
public class DoubleUtils {

	public static double divide(double ... values){
		double val1 = values[0];
		for (int i=1;i<values.length;i++){
			val1 = BigDecimal.valueOf(val1)
					.divide(BigDecimal.valueOf(values[i]),BigDecimal.ROUND_HALF_UP,BigDecimal.ROUND_DOWN)
					.doubleValue();
		}
		return val1;
	}

	public static double multiply(double ... values){
		double val1 = values[0];
		for (int i=1;i<values.length;i++){
			val1 =  BigDecimal.valueOf(val1).multiply(BigDecimal.valueOf(values[i]))
					.setScale(BigDecimal.ROUND_HALF_UP,BigDecimal.ROUND_DOWN).doubleValue();
		}
		return val1;
	}

	public static double subtract(double ... values){
		double val1 = values[0];
		for (int i=1;i<values.length;i++){
			val1 =  BigDecimal.valueOf(val1).subtract(BigDecimal.valueOf(values[i]))
					.setScale(BigDecimal.ROUND_HALF_UP,BigDecimal.ROUND_DOWN).doubleValue();
		}
		return val1;
	}

	public static double add(double ... values){
		double val1 = values[0];
		for (int i=1;i<values.length;i++){
			val1 =  BigDecimal.valueOf(val1).add(BigDecimal.valueOf(values[i]))
					.setScale(BigDecimal.ROUND_HALF_UP,BigDecimal.ROUND_DOWN).doubleValue();
		}
		return val1;
	}

	public static double pow(double val1,int val2){
		if (val2 ==0){
			return 1.0;
		}
		if (val2<0){
			return val1;
		}
		double values[] = new double[val2];
		for (int i=0;i<val2;i++){
			values[i] = val1;
		}
		return multiply(values);
	}

	//0.0003
	public static void main(String[] args) {

		double values[] = {0.3,0.3,0.3,0.3,0.3};
		System.out.println(multiply(values));

		System.out.println(pow(0.3,0));

		System.out.println(Math.pow(0.3,0));
	}
}
