/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */

package com.bxm.warcar.aspect.around;
import com.bxm.warcar.aspect.LogAspect;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

/**
 * <h3>环绕日志记录</h3>
 * <p>可能存在问题，如果此方法失败，可能会影响到该方法注解的方法失败</p>
 *
 * @author hcmony
 * @since V1.0.0, 2018/02/07 15:22
 */
@Aspect
public class LogAroundAspect extends LogAspect {

    @Around("within(com.bxm..*) && @annotation(logAround)")
    public Object doAround(ProceedingJoinPoint point, LogAround logAround){

        //开始时间
        long startTime = System.currentTimeMillis();

        //获取所有的参数
        String params = getParams(point);

        //###################上面代码为方法执行前#####################
        Object result = new Object();
        try {
            //执行方法，获取返回参数
            result = point.proceed();
            logger.info("返回参数是：{}" , result);
        }catch (Throwable e){
            logger.error(e.getMessage(),e);
        }

        //###################下面代码为方法执行后#####################
        String user = logAround.user();
        if(StringUtils.isBlank(user)){
            user = getUser(point);
        }

        logger.info("操作人：{}，\n 操作内容：{},\n 参数：{}," +
                "\n 系统是：{},,\n 返回参数是：\n 总耗时：{}s",
                user,logAround.operType(),params,logAround.keyName(),result,excTime(startTime));
        return  result;
    }

}
