/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */

package com.bxm.warcar.aspect;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.ArrayUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;

/**
 * <h3>操作日志记录基类</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2018/02/07 15:22
 */

public class LogAspect {

    protected  final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected static final String SESSION_USER_NAME = "user_name";

    protected String convent(Object args){
        try {
            return JSONObject.toJSONString(args);
        }catch (Exception e){
            return "";
        }
    }

    protected long excTime(long startTime){
        long endTime = System.currentTimeMillis();
        return (endTime-startTime)/1000;
    }

    protected Method getMethod(JoinPoint point) {
        MethodSignature methodSignature = (MethodSignature) point.getSignature();
        Class<?> targetClass = point.getTarget().getClass();
        try {
            return targetClass.getDeclaredMethod(methodSignature.getName(), methodSignature.getParameterTypes());
        } catch (NoSuchMethodException e) {
            return null;
        }
    }

    /**
     * @description 获取用户信息
     * @author hcmony
     * @time 2017/12/29
     */
    protected String getUser(JoinPoint point){
        try {
            Object[] args = point.getArgs();//获取请求参数
            HttpServletRequest request = null;
            if (ArrayUtils.isNotEmpty(args)) {
                for (Object arg : args) {
                    if(arg instanceof HttpServletRequest){
                        request = (HttpServletRequest)arg;
                        break;
                    }
                }
            }
            if(request!=null){
                return (String) request.getAttribute(SESSION_USER_NAME);
            }
        }catch (Exception e){
            logger.error("get user is null",e.getMessage());
        }
       return "-";
    }

    protected String getParams(JoinPoint point){
        Object[] args = point.getArgs();//获取请求参数
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        String[] parameterNames = methodSignature.getParameterNames();
        StringBuffer sb = new StringBuffer();

        if (ArrayUtils.isNotEmpty(args)) {
            for (int i=0;i<args.length;i++) {
                sb.append(convent(parameterNames[i]))
                        .append(":")
                        .append(convent(args[i]))
                        .append(";");
            }
        }
        return sb.toString();
    }
}