/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.cache.impls.redis;

import com.bxm.warcar.cache.DataExtractor;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.serialization.JSONSerialization;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class JedisFetcher
implements Fetcher {
    public static final String HASH_ALL_FIELD = "____ALL____";
    private final JedisPool jedisPool;
    private final JSONSerialization serialization;
    private boolean enableAllField = true;
    private String allFieldName = "____ALL____";

    public JedisFetcher(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
        this.serialization = new JSONSerialization();
    }

    @Override
    public <T> T fetch(KeyGenerator keyGenerator, DataExtractor<T> dataExtractor, Class<T> cls) {
        return this.fetch(keyGenerator, dataExtractor, cls, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T fetch(KeyGenerator keyGenerator, DataExtractor<T> dataExtractor, Class<T> cls, int expireTimeInSecond) {
        if (null == keyGenerator) {
            throw new NullPointerException("getKeyGenerator");
        }
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            String value = jedis.get(key);
            if (null != value) {
                T t = this.serialization.deserialize(value, cls);
                return t;
            }
            T fromStore = null;
            if (null != dataExtractor) {
                fromStore = dataExtractor.extract();
            }
            if (null != fromStore) {
                jedis.set(key, this.serialization.serialize(fromStore));
                if (expireTimeInSecond > 0) {
                    jedis.expire(key, expireTimeInSecond);
                }
            }
            T t = fromStore;
            return t;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public <T> List<T> fetchList(KeyGenerator keyGenerator, DataExtractor<List<T>> dataExtractor, Class<T> cls) {
        return this.fetchList(keyGenerator, dataExtractor, cls, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> fetchList(KeyGenerator keyGenerator, DataExtractor<List<T>> dataExtractor, Class<T> cls, int expireTimeInSecond) {
        if (null == keyGenerator) {
            throw new NullPointerException("getKeyGenerator");
        }
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            String value = jedis.get(key);
            if (null != value) {
                List<T> list = this.serialization.deserializeList(value, cls);
                return list;
            }
            List<T> fromStore = null;
            if (null != dataExtractor) {
                fromStore = dataExtractor.extract();
            }
            if (null != fromStore) {
                jedis.set(key, this.serialization.serialize(fromStore));
                if (expireTimeInSecond > 0) {
                    jedis.expire(key, expireTimeInSecond);
                }
            }
            List<T> list = fromStore;
            return list;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public <T> T hfetch(KeyGenerator keyGenerator, String field, DataExtractor<T> dataExtractor, Class<T> cls) {
        return this.hfetch(keyGenerator, field, dataExtractor, cls, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T hfetch(KeyGenerator keyGenerator, String field, DataExtractor<T> dataExtractor, Class<T> cls, int expireTimeInSecond) {
        if (null == keyGenerator) {
            throw new NullPointerException("getKeyGenerator");
        }
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        if (StringUtils.isBlank((String)field)) {
            throw new NullPointerException("field");
        }
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            String value = jedis.hget(key, field);
            if (null != value) {
                T t = this.serialization.deserialize(value, cls);
                return t;
            }
            T fromStore = null;
            if (null != dataExtractor) {
                fromStore = dataExtractor.extract();
            }
            if (null != fromStore) {
                jedis.hset(key, field, this.serialization.serialize(fromStore));
                if (expireTimeInSecond > 0) {
                    jedis.expire(key, expireTimeInSecond);
                }
            }
            T t = fromStore;
            return t;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public <T> Map<String, T> hfetchall(KeyGenerator keyGenerator, DataExtractor<Map<String, T>> dataExtractor, Class<T> cls) {
        return this.hfetchall(keyGenerator, dataExtractor, cls, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Map<String, T> hfetchall(KeyGenerator keyGenerator, DataExtractor<Map<String, T>> dataExtractor, Class<T> cls, int expireTimeInSecond) {
        if (null == keyGenerator) {
            throw new NullPointerException("getKeyGenerator");
        }
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        Jedis jedis = null;
        try {
            String allValFromCache;
            jedis = this.jedisPool.getResource();
            HashMap rst = Maps.newHashMap();
            Map value = null;
            if (this.enableAllField && StringUtils.isNotBlank((String)(allValFromCache = jedis.hget(key, this.allFieldName)))) {
                Map<String, T> map = this.serialization.deserializeMap(allValFromCache, cls);
                return map;
            }
            value = jedis.hgetAll(key);
            if (null != value) {
                Set entries = value.entrySet();
                for (Map.Entry entry : entries) {
                    String json = (String)entry.getValue();
                    T deserialize = this.serialization.deserialize(json, cls);
                    rst.put(entry.getKey(), deserialize);
                }
                jedis.hset(key, this.allFieldName, this.serialization.serialize(rst));
                HashMap hashMap = rst;
                return hashMap;
            }
            Map<String, T> fromStore = null;
            if (null != dataExtractor) {
                fromStore = dataExtractor.extract();
            }
            if (null != fromStore) {
                Set<Map.Entry<String, T>> entries = fromStore.entrySet();
                for (Map.Entry<String, T> entry : entries) {
                    jedis.hset(key, entry.getKey(), this.serialization.serialize(entry.getValue()));
                }
                if (expireTimeInSecond > 0) {
                    jedis.expire(key, expireTimeInSecond);
                }
            }
            Map<String, T> map = fromStore;
            return map;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    public boolean isEnableAllField() {
        return this.enableAllField;
    }

    public void setEnableAllField(boolean enableAllField) {
        this.enableAllField = enableAllField;
    }

    public String getAllFieldName() {
        return this.allFieldName;
    }

    public void setAllFieldName(String allFieldName) {
        this.allFieldName = allFieldName;
    }
}

