/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.xcache.fetchers;

import com.bxm.warcar.cache.serialization.JSONSerialization;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.xcache.Fetcher;
import com.bxm.warcar.xcache.Target;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.KeyValue;
import org.apache.commons.lang.StringUtils;

public class LoadingCacheFetcher
implements Fetcher {
    private final Fetcher source;
    private final LoadingCache<String, Optional<Object>> cache;
    private final JSONSerialization serialization;

    public LoadingCacheFetcher(Fetcher source) {
        this(source, 5, TimeUnit.MINUTES);
    }

    public LoadingCacheFetcher(Fetcher source, int duration, TimeUnit timeUnit) {
        Preconditions.checkNotNull((Object)source);
        this.source = source;
        this.cache = CacheBuilder.newBuilder().expireAfterWrite((long)duration, timeUnit).build((CacheLoader)new CacheLoader<String, Optional<Object>>(){

            public Optional<Object> load(String key) throws Exception {
                return Optional.empty();
            }
        });
        this.serialization = new JSONSerialization();
    }

    @Override
    public <T> T fetch(Target<T> target) {
        Preconditions.checkNotNull(target);
        try {
            if (target.isSkipNativeCache()) {
                return this.source.fetch(target);
            }
            Optional s = (Optional)this.cache.get((Object)target.getKeyGenerator().generateKey(), () -> {
                Object value = this.source.fetch(target);
                return Optional.ofNullable(value);
            });
            T value = s.orElse(null);
            if (null == value) {
                return null;
            }
            return value;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    @Override
    public <T> List<T> fetchToList(Target<T> target) {
        Preconditions.checkNotNull(target);
        try {
            if (target.isSkipNativeCache()) {
                return this.source.fetchToList(target);
            }
            Optional s = (Optional)this.cache.get((Object)target.getKeyGenerator().generateKey(), () -> {
                List value = this.source.fetchToList(target);
                return Optional.ofNullable(value);
            });
            Object value = s.orElse(null);
            if (null == value) {
                return null;
            }
            return value;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    @Override
    public <T> T hfetch(Target<T> target) {
        Preconditions.checkNotNull(target);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)target.getField()));
        try {
            if (target.isSkipNativeCache()) {
                return this.source.hfetch(target);
            }
            String key = KeyBuilder.build((Object[])new Object[]{target.getKeyGenerator().generateKey(), target.getField()});
            Optional s = (Optional)this.cache.get((Object)key, () -> {
                Object value = this.source.hfetch(target);
                return Optional.ofNullable(value);
            });
            T value = s.orElse(null);
            if (null == value) {
                return null;
            }
            return value;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    @Override
    public <T> List<T> hfetchToList(Target<T> target) {
        Preconditions.checkNotNull(target);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)target.getField()));
        try {
            if (target.isSkipNativeCache()) {
                return this.source.hfetchToList(target);
            }
            String key = KeyBuilder.build((Object[])new Object[]{target.getKeyGenerator().generateKey(), target.getField()});
            Optional s = (Optional)this.cache.get((Object)key, () -> {
                List value = this.source.hfetchToList(target);
                return Optional.ofNullable(value);
            });
            Object value = s.orElse(null);
            if (null == value) {
                return null;
            }
            return value;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    @Override
    public <T> Map<String, T> hfetchall(Target<T> target) {
        Preconditions.checkNotNull(target);
        try {
            if (target.isSkipNativeCache()) {
                return this.source.hfetchall(target);
            }
            Optional s = (Optional)this.cache.get((Object)target.getKeyGenerator().generateKey(), () -> {
                Map value = this.source.hfetchall(target);
                return Optional.ofNullable(value);
            });
            Object value = s.orElse(null);
            if (null == value) {
                return null;
            }
            return value;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    @Override
    public <T> List<T> zfetch(Target<T> target) {
        Preconditions.checkNotNull(target);
        try {
            if (target.isSkipNativeCache()) {
                return this.source.zfetch(target);
            }
            Optional s = (Optional)this.cache.get((Object)target.getKeyGenerator().generateKey(), () -> {
                List value = this.source.zfetch(target);
                return Optional.ofNullable(value);
            });
            Object value = s.orElse(null);
            if (null == value) {
                return null;
            }
            return value;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    @Override
    public <T> List<KeyValue> zfetchall(Target<T> target) {
        Preconditions.checkNotNull(target);
        try {
            if (target.isSkipNativeCache()) {
                return this.source.zfetchall(target);
            }
            Optional s = (Optional)this.cache.get((Object)target.getKeyGenerator().generateKey(), () -> {
                List<KeyValue> value = this.source.zfetchall(target);
                return Optional.ofNullable(value);
            });
            Object value = s.orElse(null);
            if (null == value) {
                return null;
            }
            return value;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    @Override
    public <T> long distinct(Target<T> target) {
        Preconditions.checkNotNull(target);
        try {
            if (target.isSkipNativeCache()) {
                return this.source.distinct(target);
            }
            Optional s = (Optional)this.cache.get((Object)target.getKeyGenerator().generateKey(), () -> {
                long value = this.source.distinct(target);
                return Optional.of(value);
            });
            Integer value = s.orElse(0);
            return (Long)((Object)value);
        }
        catch (ExecutionException e) {
            return 0L;
        }
    }

    @Override
    public <T> T getClientOriginal() {
        return (T)this.cache;
    }
}

