package com.bxm.warcar.cache;

/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2019/10/31 16:00
 */
public interface RedisLock {

    /**
     * 加锁
     *
     * @param key
     * @param rid
     * @param expireTime 这里是毫秒
     * @return
     */
    public boolean tryLock(String key, String rid, int expireTime);

    /**
     * 加锁,默认失效60秒
     *
     * @param key
     * @param rid
     * @return
     */
    public boolean tryLock(String key, String rid);

    /**
     * 解锁
     *
     * @param key
     * @param rid
     * @return
     */
    public boolean unLock(String key, String rid) ;
}
