/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.cache.impls.redis;

import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.TypeHelper;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

public class JedisCounter
implements Counter {
    private final JedisPool jedisPool;

    public JedisCounter(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    @Override
    public Object getClientOriginal() {
        return this.jedisPool;
    }

    @Override
    public Long incrementAndGet(KeyGenerator keyGenerator) {
        return this.incrementAndGet(keyGenerator, 0);
    }

    @Override
    public Long incrementAndGet(KeyGenerator keyGenerator, int expireTimeInSecond) {
        return this.incrementAndGet(keyGenerator, expireTimeInSecond, incr -> true);
    }

    @Override
    public Long incrementAndGet(KeyGenerator keyGenerator, int expireTimeInSecond, Predicate<Long> updateExpireTime) {
        Objects.requireNonNull(updateExpireTime);
        String key = this.getKey(keyGenerator);
        try (Jedis jedis = this.jedisPool.getResource();){
            Long incr = jedis.incr(key);
            if (updateExpireTime.test(incr)) {
                this.setExpire(jedis, key, expireTimeInSecond);
            }
            Long l = incr;
            return l;
        }
    }

    @Override
    public Long incrementByAndGet(KeyGenerator keyGenerator, long inc) {
        return this.incrementByAndGet(keyGenerator, inc, 0);
    }

    @Override
    public Long incrementByAndGet(KeyGenerator keyGenerator, long inc, int expireTimeInSecond) {
        return this.incrementByAndGet(keyGenerator, inc, expireTimeInSecond, incr -> true);
    }

    @Override
    public Long incrementByAndGet(KeyGenerator keyGenerator, long inc, int expireTimeInSecond, Predicate<Long> updateExpireTime) {
        Objects.requireNonNull(updateExpireTime);
        String key = this.getKey(keyGenerator);
        try (Jedis jedis = this.jedisPool.getResource();){
            Long incr = jedis.incrBy(key, inc);
            if (updateExpireTime.test(incr)) {
                this.setExpire(jedis, key, expireTimeInSecond);
            }
            Long l = incr;
            return l;
        }
    }

    @Override
    public Double incrFloatByAndGet(KeyGenerator keyGenerator, double inc) {
        return this.incrFloatByAndGet(keyGenerator, inc, 0);
    }

    @Override
    public Double incrFloatByAndGet(KeyGenerator keyGenerator, double inc, int expireTimeInSecond) {
        String key = this.getKey(keyGenerator);
        try (Jedis jedis = this.jedisPool.getResource();){
            Double incr = jedis.incrByFloat(key, inc);
            this.setExpire(jedis, key, expireTimeInSecond);
            Double d = incr;
            return d;
        }
    }

    @Override
    public Long decrementAndGet(KeyGenerator keyGenerator) {
        return this.decrementAndGet(keyGenerator, 0);
    }

    @Override
    public Long decrementAndGet(KeyGenerator keyGenerator, int expireTimeInSecond) {
        String key = this.getKey(keyGenerator);
        try (Jedis jedis = this.jedisPool.getResource();){
            Long decr = jedis.decr(key);
            this.setExpire(jedis, key, expireTimeInSecond);
            Long l = decr;
            return l;
        }
    }

    @Override
    public Long decrementByAndGet(KeyGenerator keyGenerator, long dec) {
        return this.decrementByAndGet(keyGenerator, dec, 0);
    }

    @Override
    public Long decrementByAndGet(KeyGenerator keyGenerator, long dec, int expireTimeInSecond) {
        String key = this.getKey(keyGenerator);
        try (Jedis jedis = this.jedisPool.getResource();){
            Long decr = jedis.decrBy(key, dec);
            this.setExpire(jedis, key, expireTimeInSecond);
            Long l = decr;
            return l;
        }
    }

    @Override
    public void set(KeyGenerator keyGenerator, long value) {
        String key = this.getKey(keyGenerator);
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.set(key, String.valueOf(value));
        }
    }

    @Override
    public void expire(KeyGenerator keyGenerator, int seconds) {
        String key = this.getKey(keyGenerator);
        try (Jedis jedis = this.jedisPool.getResource();){
            this.setExpire(jedis, key, seconds);
        }
    }

    @Override
    public Long get(KeyGenerator keyGenerator) {
        String key = this.getKey(keyGenerator);
        try (Jedis jedis = this.jedisPool.getResource();){
            Long l = TypeHelper.castToLong((Object)jedis.get(key));
            return l;
        }
    }

    @Override
    public Long hincrementAndGet(KeyGenerator keyGenerator, String field) {
        return this.hincrementAndGet(keyGenerator, field, 0);
    }

    @Override
    public Long hincrementAndGet(KeyGenerator keyGenerator, String field, int expireTimeInSecond) {
        return this.hincrementByAndGet(keyGenerator, field, 1L, expireTimeInSecond);
    }

    @Override
    public Long hincrementAndGet(KeyGenerator keyGenerator, String field, int expireTimeInSecond, Predicate<Long> updateExpireTime) {
        return this.hincrementByAndGet(keyGenerator, field, 1L, expireTimeInSecond, updateExpireTime);
    }

    @Override
    public Long hincrementByAndGet(KeyGenerator keyGenerator, String field, long inc) {
        return this.hincrementByAndGet(keyGenerator, field, inc, 0);
    }

    @Override
    public Long hincrementByAndGet(KeyGenerator keyGenerator, String field, long inc, int expireTimeInSecond) {
        return this.hincrementByAndGet(keyGenerator, field, inc, expireTimeInSecond, h -> true);
    }

    @Override
    public Long hincrementByAndGet(KeyGenerator keyGenerator, String field, long inc, int expireTimeInSecond, Predicate<Long> updateExpireTime) {
        Objects.requireNonNull(updateExpireTime);
        String key = this.getKey(keyGenerator);
        try (Jedis jedis = this.jedisPool.getResource();){
            Long hincr = jedis.hincrBy(key, field, inc);
            if (updateExpireTime.test(hincr)) {
                this.setExpire(jedis, key, expireTimeInSecond);
            }
            Long l = hincr;
            return l;
        }
    }

    @Override
    public Double hincrFloatByAndGet(KeyGenerator keyGenerator, String field, double inc) {
        return this.hincrFloatByAndGet(keyGenerator, field, inc, 0);
    }

    @Override
    public Double hincrFloatByAndGet(KeyGenerator keyGenerator, String field, double inc, int expireTimeInSecond) {
        String key = this.getKey(keyGenerator);
        try (Jedis jedis = this.jedisPool.getResource();){
            Double decr = jedis.hincrByFloat(key, field, inc);
            this.setExpire(jedis, key, expireTimeInSecond);
            Double d = decr;
            return d;
        }
    }

    @Override
    public Long hget(KeyGenerator keyGenerator, String field) {
        String key = this.getKey(keyGenerator);
        try (Jedis jedis = this.jedisPool.getResource();){
            String v = jedis.hget(key, field);
            Long l = NumberUtils.toLong((String)v, (long)0L);
            return l;
        }
    }

    @Override
    public Map<String, Long> hgetall(KeyGenerator keyGenerator) {
        String key = this.getKey(keyGenerator);
        try (Jedis jedis = this.jedisPool.getResource();){
            HashMap rst = Maps.newHashMap();
            String startCursor = "0";
            String cursor = "0";
            do {
                ScanResult hscan = jedis.hscan(key, cursor, new ScanParams().count(Integer.valueOf(10000)));
                cursor = hscan.getCursor();
                List result = hscan.getResult();
                if (!CollectionUtils.isNotEmpty((Collection)result)) continue;
                for (Map.Entry entry : result) {
                    String k = (String)entry.getKey();
                    String v = (String)entry.getValue();
                    rst.put(k, NumberUtils.toLong((String)v));
                }
            } while (!cursor.equals("0"));
            HashMap hashMap = rst;
            return hashMap;
        }
    }

    private void setExpire(Jedis jedis, String key, int expireTimeInSecond) {
        if (expireTimeInSecond > 0) {
            jedis.expire(key, (long)expireTimeInSecond);
        }
    }

    private String getKey(KeyGenerator keyGenerator) {
        if (null == keyGenerator) {
            throw new NullPointerException("getKeyGenerator");
        }
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        return key;
    }
}

