/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.cache.push;

import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Converter;
import com.bxm.warcar.cache.push.HashUpdating;
import com.bxm.warcar.cache.push.Pushable;
import com.google.common.base.Preconditions;
import java.util.Map;

public abstract class AbstractPushable<T>
implements Pushable {
    protected final Converter converter;

    public AbstractPushable() {
        this(Converter.DEFAULT);
    }

    public AbstractPushable(Converter converter) {
        this.converter = converter;
    }

    protected abstract Updater getUpdater();

    protected int getExpireTimeInSeconds() {
        return -1;
    }

    protected void beforeUpdate(Map<String, Object> parameters, byte[] data, T object) {
    }

    protected void afterUpdated(Map<String, Object> parameters, T object) {
    }

    protected void doUpdate(T object, KeyGenerator keyGenerator, Map<String, Object> parameters, byte[] data) {
        Updater updater = this.getUpdater();
        Preconditions.checkNotNull((Object)updater);
        this.beforeUpdate(parameters, data, object);
        Object o = this.converter.convert(object);
        if (this instanceof HashUpdating) {
            String field = ((HashUpdating)((Object)this)).getField(parameters, object);
            updater.hremove(keyGenerator, field);
            if (null != o) {
                updater.hupdate(keyGenerator, field, o, this.getExpireTimeInSeconds());
            }
        } else {
            updater.remove(keyGenerator);
            if (null != o) {
                updater.update(keyGenerator, o, this.getExpireTimeInSeconds());
            }
        }
        this.afterUpdated(parameters, object);
    }
}

