/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.xcache.fetchers;

import com.bxm.warcar.cache.DataExtractor;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.serialization.JSONSerialization;
import com.bxm.warcar.xcache.Fetcher;
import com.bxm.warcar.xcache.Target;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.KeyValue;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.keyvalue.DefaultKeyValue;
import org.apache.commons.lang.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.Tuple;

public class RedisFetcher
implements Fetcher {
    private final JedisPool jedisPool;
    private final JSONSerialization serialization;

    public RedisFetcher(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
        this.serialization = new JSONSerialization();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T fetch(Target<T> target) {
        Preconditions.checkNotNull(target);
        KeyGenerator keyGenerator = target.getKeyGenerator();
        Class<T> cls = target.getCls();
        DataExtractor<T> dataExtractor = target.getDataExtractor();
        int selector = target.getSelector();
        int expireTimeInSecond = target.getExpireTimeInSecond();
        if (null == keyGenerator) {
            throw new NullPointerException("getKeyGenerator");
        }
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        Jedis jedis = null;
        try {
            String value;
            jedis = this.jedisPool.getResource();
            if (selector >= 0) {
                jedis.select(selector);
            }
            if (null != (value = jedis.get(key))) {
                T t = this.serialization.deserialize(value, cls);
                return t;
            }
            T fromStore = null;
            if (null != dataExtractor) {
                fromStore = dataExtractor.extract();
                expireTimeInSecond = dataExtractor.updateExpireTimeInSecond(fromStore, expireTimeInSecond);
            }
            if (null != fromStore) {
                jedis.set(key, this.serialization.serialize(fromStore));
                if (expireTimeInSecond > 0) {
                    jedis.expire(key, expireTimeInSecond);
                }
            }
            T t = fromStore;
            return t;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> fetchToList(Target<T> target) {
        Preconditions.checkNotNull(target);
        KeyGenerator keyGenerator = target.getKeyGenerator();
        Class<T> cls = target.getCls();
        DataExtractor<List<List<T>>> dataExtractor = target.getListDataExtractor();
        int selector = target.getSelector();
        int expireTimeInSecond = target.getExpireTimeInSecond();
        if (null == keyGenerator) {
            throw new NullPointerException("getKeyGenerator");
        }
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        Jedis jedis = null;
        try {
            String value;
            jedis = this.jedisPool.getResource();
            if (selector >= 0) {
                jedis.select(selector);
            }
            if (null != (value = jedis.get(key))) {
                List<T> list = this.serialization.deserializeList(value, cls);
                return list;
            }
            List<T> fromStore = null;
            if (null != dataExtractor) {
                fromStore = dataExtractor.extract();
                expireTimeInSecond = dataExtractor.updateExpireTimeInSecond(fromStore, expireTimeInSecond);
            }
            if (null != fromStore) {
                jedis.set(key, this.serialization.serialize(fromStore));
                if (expireTimeInSecond > 0) {
                    jedis.expire(key, expireTimeInSecond);
                }
            }
            List<T> list = fromStore;
            return list;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T hfetch(Target<T> target) {
        Preconditions.checkNotNull(target);
        KeyGenerator keyGenerator = target.getKeyGenerator();
        Class<T> cls = target.getCls();
        DataExtractor<T> dataExtractor = target.getDataExtractor();
        int selector = target.getSelector();
        int expireTimeInSecond = target.getExpireTimeInSecond();
        String field = target.getField();
        if (null == keyGenerator) {
            throw new NullPointerException("getKeyGenerator");
        }
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        if (StringUtils.isBlank((String)field)) {
            throw new NullPointerException("field");
        }
        Jedis jedis = null;
        try {
            String value;
            jedis = this.jedisPool.getResource();
            if (selector >= 0) {
                jedis.select(selector);
            }
            if (null != (value = jedis.hget(key, field))) {
                T t = this.serialization.deserialize(value, cls);
                return t;
            }
            T fromStore = null;
            if (null != dataExtractor) {
                fromStore = dataExtractor.extract();
                expireTimeInSecond = dataExtractor.updateExpireTimeInSecond(fromStore, expireTimeInSecond);
            }
            if (null != fromStore) {
                jedis.hset(key, field, this.serialization.serialize(fromStore));
                if (expireTimeInSecond > 0) {
                    jedis.expire(key, expireTimeInSecond);
                }
            }
            T t = fromStore;
            return t;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> hfetchToList(Target<T> target) {
        Preconditions.checkNotNull(target);
        KeyGenerator keyGenerator = target.getKeyGenerator();
        Class<T> cls = target.getCls();
        DataExtractor<List<List<T>>> dataExtractor = target.getListDataExtractor();
        int selector = target.getSelector();
        int expireTimeInSecond = target.getExpireTimeInSecond();
        String field = target.getField();
        if (null == keyGenerator) {
            throw new NullPointerException("getKeyGenerator");
        }
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        if (StringUtils.isBlank((String)field)) {
            throw new NullPointerException("field");
        }
        Jedis jedis = null;
        try {
            String value;
            jedis = this.jedisPool.getResource();
            if (selector >= 0) {
                jedis.select(selector);
            }
            if (null != (value = jedis.hget(key, field))) {
                List<T> list = this.serialization.deserializeList(value, cls);
                return list;
            }
            List<T> fromStore = null;
            if (null != dataExtractor) {
                fromStore = dataExtractor.extract();
                expireTimeInSecond = dataExtractor.updateExpireTimeInSecond(fromStore, expireTimeInSecond);
            }
            if (null != fromStore) {
                jedis.hset(key, field, this.serialization.serialize(fromStore));
                if (expireTimeInSecond > 0) {
                    jedis.expire(key, expireTimeInSecond);
                }
            }
            List<T> list = fromStore;
            return list;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Map<String, T> hfetchall(Target<T> target) {
        Preconditions.checkNotNull(target);
        KeyGenerator keyGenerator = target.getKeyGenerator();
        Class<T> cls = target.getCls();
        DataExtractor<Map<String, Map<String, T>>> dataExtractor = target.getMapDataExtractor();
        int selector = target.getSelector();
        int expireTimeInSecond = target.getExpireTimeInSecond();
        if (null == keyGenerator) {
            throw new NullPointerException("getKeyGenerator");
        }
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        Jedis jedis = null;
        try {
            Object hscan;
            jedis = this.jedisPool.getResource();
            if (selector >= 0) {
                jedis.select(selector);
            }
            HashMap rst = Maps.newHashMap();
            String startCursor = "0";
            String cursor = "0";
            ScanParams scanParams = new ScanParams().count(Integer.valueOf(target.getBatchSize()));
            do {
                hscan = jedis.hscan(key, cursor, scanParams);
                cursor = hscan.getCursor();
                List result = hscan.getResult();
                if (!CollectionUtils.isNotEmpty((Collection)result)) continue;
                for (Map.Entry entry : result) {
                    String k = (String)entry.getKey();
                    String v = (String)entry.getValue();
                    rst.put(k, this.serialization.deserialize(v, cls));
                }
            } while (!cursor.equals("0"));
            if (MapUtils.isNotEmpty((Map)rst)) {
                hscan = rst;
                return hscan;
            }
            Map<String, T> fromStore = null;
            if (null != dataExtractor) {
                fromStore = dataExtractor.extract();
                expireTimeInSecond = dataExtractor.updateExpireTimeInSecond(fromStore, expireTimeInSecond);
            }
            if (null != fromStore) {
                Set<Map.Entry<String, T>> entries = fromStore.entrySet();
                for (Map.Entry entry : entries) {
                    jedis.hset(key, (String)entry.getKey(), this.serialization.serialize(entry.getValue()));
                }
                if (expireTimeInSecond > 0) {
                    jedis.expire(key, expireTimeInSecond);
                }
            }
            Map<String, T> map = fromStore;
            return map;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Set<T> sfetchall(Target<T> target) {
        Preconditions.checkNotNull(target);
        KeyGenerator keyGenerator = target.getKeyGenerator();
        Class<T> cls = target.getCls();
        int selector = target.getSelector();
        if (null == keyGenerator) {
            throw new NullPointerException("keyGenerator");
        }
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            if (selector >= 0) {
                jedis.select(selector);
            }
            HashSet rs = Sets.newHashSet();
            String cursor = "0";
            ScanParams scanParams = new ScanParams().count(Integer.valueOf(target.getBatchSize()));
            do {
                ScanResult scanResult = jedis.sscan(key, cursor, scanParams);
                cursor = scanResult.getCursor();
                List result = scanResult.getResult();
                if (!CollectionUtils.isNotEmpty((Collection)result)) continue;
                for (String s : result) {
                    rs.add(this.serialization.deserialize(s, cls));
                }
            } while (!"0".equals(cursor));
            HashSet hashSet = rs;
            return hashSet;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> zfetch(Target<T> target) {
        Preconditions.checkNotNull(target);
        KeyGenerator keyGenerator = target.getKeyGenerator();
        Class<T> cls = target.getCls();
        int selector = target.getSelector();
        if (null == keyGenerator) {
            throw new NullPointerException("getKeyGenerator");
        }
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            if (selector >= 0) {
                jedis.select(selector);
            }
            ArrayList rst = Lists.newArrayList();
            String cursor = "0";
            ScanParams scanParams = new ScanParams().count(Integer.valueOf(target.getBatchSize()));
            do {
                ScanResult zscan = jedis.zscan(key, cursor, scanParams);
                cursor = zscan.getCursor();
                List result = zscan.getResult();
                if (!CollectionUtils.isNotEmpty((Collection)result)) continue;
                for (Tuple t : result) {
                    rst.add(this.serialization.deserialize(t.getElement(), cls));
                }
            } while (!"0".equals(cursor));
            ArrayList arrayList = rst;
            return arrayList;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<KeyValue> zfetchall(Target<T> target) {
        Preconditions.checkNotNull(target);
        KeyGenerator keyGenerator = target.getKeyGenerator();
        Class<T> cls = target.getCls();
        int selector = target.getSelector();
        if (null == keyGenerator) {
            throw new NullPointerException("getKeyGenerator");
        }
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            if (selector >= 0) {
                jedis.select(selector);
            }
            ArrayList rs = Lists.newArrayList();
            String cursor = "0";
            ScanParams scanParams = new ScanParams().count(Integer.valueOf(target.getBatchSize()));
            do {
                ScanResult zscan = jedis.zscan(key, cursor, scanParams);
                cursor = zscan.getCursor();
                List result = zscan.getResult();
                if (!CollectionUtils.isNotEmpty((Collection)result)) continue;
                for (Tuple t : result) {
                    DefaultKeyValue kv = new DefaultKeyValue();
                    kv.setKey(this.serialization.deserialize(t.getElement(), cls));
                    kv.setValue((Object)t.getScore());
                    rs.add(kv);
                }
            } while (!"0".equals(cursor));
            ArrayList arrayList = rs;
            return arrayList;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> long distinct(Target<T> target) {
        Preconditions.checkNotNull(target);
        KeyGenerator keyGenerator = target.getKeyGenerator();
        int selector = target.getSelector();
        if (null == keyGenerator) {
            throw new NullPointerException("getKeyGenerator");
        }
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            if (selector >= 0) {
                jedis.select(selector);
            }
            long l = jedis.pfcount(key);
            return l;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public <T> T getClientOriginal() {
        return (T)this.jedisPool;
    }
}

