package com.bxm.warcar.configure.test;

import com.bxm.warcar.cache.Fetcher;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;
import java.util.Properties;

/**
 * @author allen
 * @since 2019-12-23
 */
@RefreshScope
@RestController
public class ConfigureController {

    private final ConfigurableEnvironment environment;
    private final ConfigureProperties configureProperties;

    private final Fetcher fetcher;
    private final Configures configures;

    @Value("${configure.el:12}")
    private String el;

    public ConfigureController(ConfigurableEnvironment environment, ConfigureProperties configureProperties, Fetcher fetcher, Configures configures) {
        this.environment = environment;
        this.configureProperties = configureProperties;
        this.fetcher = fetcher;
        this.configures = configures;
    }

    @GetMapping("/")
    public ResponseEntity<Object> getEnvironment() {
        MutablePropertySources propertySources = environment.getPropertySources();
        for (PropertySource<?> propertySource : propertySources) {
            if (propertySource.getName().startsWith("userRemoteDefinedProperties")) {
                return ResponseEntity.ok(propertySource);
            }
        }
        return ResponseEntity.ok(propertySources);
    }

    @GetMapping("/config")
    public ResponseEntity<Object> config() {
        return ResponseEntity.ok(configureProperties);
    }

    @GetMapping("/els")
    public ResponseEntity<Object> els() {
        return ResponseEntity.ok(configures.getDemo());
    }

    @GetMapping("/keys")
    public ResponseEntity<Object> keys() {
        Map<String, String> map = fetcher.hfetchall(() -> "AD:TICKET:AVAILABLE", String.class);
        return ResponseEntity.ok(map);
    }

    @PutMapping("/put")
    public ResponseEntity<Boolean> put(String key, String value) {
        MutablePropertySources propertySources = environment.getPropertySources();
        for (PropertySource<?> propertySource : propertySources) {
            if (propertySource.getName().startsWith("userRemoteDefinedProperties")) {
                Object properties = propertySource.getSource();
                if (properties instanceof Properties) {
                    ((Properties) properties).put(key, value);
                    return ResponseEntity.ok(true);
                }
            }
        }
        return ResponseEntity.ok(false);
    }
}
