/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.configure.spring;

import com.bxm.warcar.configure.EnvironmentLoader;
import com.bxm.warcar.configure.loader.EnvironmentLoaderFactory;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

public final class SpringBootEnvironmentListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringBootEnvironmentListener.class);
    private static final String ADDRESS = "configure.address";
    private static final String KEY = "configure.key";

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        EnvironmentLoader environmentLoader;
        ConfigurableEnvironment environment = event.getEnvironment();
        boolean contains = environment.containsProperty(ADDRESS);
        if (!contains) {
            return;
        }
        String address = environment.getProperty(ADDRESS);
        String key = environment.getProperty(KEY);
        if (null == address || null == key) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Environment property '{}','{}' must not be null.", (Object)ADDRESS, (Object)KEY);
            }
            return;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Loading properties '{}' from {}", (Object)key, (Object)address);
        }
        if (null == (environmentLoader = EnvironmentLoaderFactory.create(address.toString(), key.toString()))) {
            return;
        }
        List<Properties> properties = environmentLoader.loadProperties();
        this.closeLoader(environmentLoader);
        if (null != properties) {
            for (int i = 0; i < properties.size(); ++i) {
                environment.getPropertySources().addFirst((PropertySource)new PropertiesPropertySource("userRemoteDefinedProperties-" + i, properties.get(i)));
            }
        }
    }

    private void closeLoader(EnvironmentLoader environmentLoader) {
        try {
            environmentLoader.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

