/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.configure.reader.properties;

import com.bxm.warcar.configure.PropertiesReader;
import com.bxm.warcar.utils.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;

/**
 * <h3>*.properties reader</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/21
 */
public class PropertiesPropertiesReader implements PropertiesReader {

    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesPropertiesReader.class);

    @Override
    public Properties read(byte[] bytes) {
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(StringHelper.convert(bytes)));
            return properties;
        } catch (IOException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("read:", e);
            }
            return null;
        }
    }
}
