package com.bxm.warcar.datasync.client.triggers.zk;

import com.bxm.warcar.datasync.client.Action;
import com.bxm.warcar.datasync.client.Trigger;
import com.bxm.warcar.datasync.serialization.Serialization;
import com.bxm.warcar.datasync.server.sync.SyncCache;
import com.bxm.warcar.datasync.source.SourceController;
import com.bxm.warcar.zk.listener.ChildrenChangedListener;
import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author allen
 * @date 2019/4/3
 * @since 1.0.0
 */
public class ZkChildrenChangedListener implements ChildrenChangedListener, Trigger {

    private static final Logger LOGGER = LoggerFactory.getLogger(ZkChildrenChangedListener.class);
    private final Action action;
    private final SourceController sourceController;
    private final Serialization serialization = new Serialization() {
    };

    public ZkChildrenChangedListener(Action action, SourceController sourceController) {
        Preconditions.checkNotNull(action);
        Preconditions.checkNotNull(sourceController);
        this.action = action;
        this.sourceController = sourceController;
    }

    @Override
    public void add(String path, byte[] data) {
        try {
            SyncCache syncCache = SyncCache.of(data);
            String key = syncCache.getId();
            String value = fetch(key);
            action.add(key, serialization.deserialize(value, syncCache.getCls()));
        } catch (Exception e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("add: " + path, e);
            }
        }
    }

    @Override
    public void remove(String path, byte[] data) {
        try {
            SyncCache syncCache = SyncCache.of(data);
            String key = syncCache.getId();
            action.remove(key);
        } catch (Exception e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("remove: " + path, e);
            }
        }
    }

    @Override
    public void update(String path, byte[] data) {
        try {
            SyncCache syncCache = SyncCache.of(data);
            String key = syncCache.getId();
            String value = fetch(key);
            action.update(key, serialization.deserialize(value, syncCache.getCls()));
        } catch (Exception e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("update: " + path, e);
            }
        }
    }

    private String fetch(String key) {
        return sourceController.get(key);
    }
}
