/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.datasync.client.actions;

import com.bxm.warcar.datasync.client.Action;
import com.bxm.warcar.datasync.client.cache.MutableCache;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheAction
implements Action {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheAction.class);
    private final MutableCache mutableCache;

    public CacheAction(MutableCache mutableCache) {
        Preconditions.checkNotNull((Object)mutableCache);
        this.mutableCache = mutableCache;
    }

    @Override
    public void add(String key, Object value) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)key), (Object)"key");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)key), (Object)"value");
        this.mutableCache.set(key, value);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("added cache: {}", (Object)key);
        }
    }

    @Override
    public void update(String key, Object value) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)key), (Object)"key");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)key), (Object)"value");
        this.mutableCache.set(key, value);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("updated cache: {}", (Object)key);
        }
    }

    @Override
    public void remove(String key) {
        if (StringUtils.isBlank((String)key)) {
            return;
        }
        this.mutableCache.del(key);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("deleted cache: {}", (Object)key);
        }
    }
}

