package com.bxm.warcar.datasync.server;

import com.bxm.warcar.datasync.server.sync.SyncOperationException;
import com.bxm.warcar.datasync.source.SourceOperationException;
import com.bxm.warcar.datasync.utils.KeyHelper;

/**
 * 数据同步提供者
 *
 * @author allen
 * @date 2019/4/2
 * @since 1.0.0
 */
public interface DataSyncProducer {

    /**
     * 提交内容。如果提交发生异常建议根据业务来判断是否重试或回滚事物。
     *
     * @param key 内容key，建议使用{@linkplain KeyHelper 工具类}来构建。
     * @param value 内容
     * @throws SourceOperationException 源操作异常
     * @throws SyncOperationException 同步服务操作异常
     * @throws IllegalArgumentException 无效的参数
     */
    void post(String key, Object value) throws SourceOperationException, SyncOperationException, IllegalArgumentException;

    /**
     * 删除指定内容。
     * @param key 内容key
     */
    void delete(String key);
}
