/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.datasync.client.cache;

import com.bxm.warcar.datasync.client.cache.DataSyncHandler;
import com.bxm.warcar.datasync.client.cache.MutableCache;
import com.bxm.warcar.zk.listener.children.ChildrenChanged;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;

public class DataSyncHandlerDispatcher
implements MutableCache,
ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(DataSyncHandlerDispatcher.class);
    private final Map<Class<?>, DataSyncHandler> handlers = Maps.newHashMap();

    public void onApplicationEvent(ApplicationReadyEvent event) {
        ChildrenChanged childrenChanged = (ChildrenChanged)event.getApplicationContext().getBean(ChildrenChanged.class);
        childrenChanged.init();
        Map beans = event.getApplicationContext().getBeansOfType(DataSyncHandler.class);
        for (Map.Entry entry : beans.entrySet()) {
            DataSyncHandler handler = (DataSyncHandler)entry.getValue();
            this.handlers.put(handler.getClazz(), handler);
            log.info("Registered {}", (Object)handler);
        }
    }

    @Override
    public Object set(String key, Object value, Class<?> clazz) throws NullPointerException {
        if (Objects.isNull(key)) {
            log.warn("key is null!");
            return null;
        }
        if (Objects.isNull(value)) {
            log.warn("value is null by key: {}", (Object)key);
            return null;
        }
        DataSyncHandler dataSyncHandler = this.handlers.get(clazz);
        if (Objects.isNull(dataSyncHandler)) {
            log.warn("Does not found DataSyncHandler matching class {}", clazz);
            return null;
        }
        return dataSyncHandler.set(key, value);
    }

    @Override
    public void del(String key, Class<?> clazz) {
        DataSyncHandler dataSyncHandler = this.handlers.get(clazz);
        if (Objects.isNull(dataSyncHandler)) {
            log.warn("Does not found DataSyncHandler matching class {}", clazz);
            return;
        }
        dataSyncHandler.del(key);
    }

    @Override
    public <T> T get(String key) throws NullPointerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Object> getAll() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long size() {
        return -1L;
    }
}

