/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.datasync.server;

import com.bxm.warcar.datasync.serialization.Serialization;
import com.bxm.warcar.datasync.server.DataSyncProducer;
import com.bxm.warcar.datasync.server.sync.SyncController;
import com.bxm.warcar.datasync.server.sync.SyncOperationException;
import com.bxm.warcar.datasync.source.SourceController;
import com.bxm.warcar.datasync.source.SourceOperationException;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;

public class DefaultDataSyncProducer
implements DataSyncProducer {
    private final SyncController syncController;
    private final SourceController sourceController;
    private final Serialization serialization = new Serialization(){};

    public DefaultDataSyncProducer(SyncController syncController, SourceController sourceController) {
        Preconditions.checkNotNull((Object)syncController);
        Preconditions.checkNotNull((Object)sourceController);
        this.syncController = syncController;
        this.sourceController = sourceController;
    }

    @Override
    public void post(String key, Object value) throws SourceOperationException, SyncOperationException, IllegalArgumentException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)key), (Object)"key");
        Preconditions.checkNotNull((Object)value, (Object)"value");
        if (!this.sourceController.set(key, this.serialization.serialize(value))) {
            throw new SourceOperationException();
        }
        if (!this.syncController.update(key, value.getClass())) {
            throw new SyncOperationException();
        }
    }

    @Override
    public void delete(String key) {
        this.sourceController.delete(key);
        this.syncController.delete(key);
    }
}

