/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.dpl.impl;

import com.bxm.warcar.dpl.Plugin;
import com.bxm.warcar.dpl.PluginConfig;
import com.bxm.warcar.dpl.impl.PluginApplicationContext;
import com.google.common.base.Preconditions;
import java.beans.Introspector;
import java.util.Date;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.logging.LogFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.AbstractHandlerMethodMapping;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

public class SpringPlugin
implements Plugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringPlugin.class);
    private final PluginConfig pluginConfig;
    private final Date creation;
    private final PluginApplicationContext applicationContext;

    public SpringPlugin(PluginConfig pluginConfig, PluginApplicationContext applicationContext) {
        this.pluginConfig = pluginConfig;
        this.creation = new Date();
        this.applicationContext = applicationContext;
    }

    @Override
    public String getName() {
        return this.pluginConfig.getName();
    }

    @Override
    public String getVersion() {
        return this.pluginConfig.getVersion();
    }

    @Override
    public Date getCreation() {
        return this.creation;
    }

    @Override
    public void destroy() {
        this.unregisterMapping();
        SpringPlugin.closeQuietly((ConfigurableApplicationContext)this.applicationContext);
        SpringPlugin.clear(this.applicationContext.getClassLoader());
    }

    private void unregisterMapping() {
        Map<RequestMappingInfo, HandlerMethod> mappings = this.applicationContext.getMappings();
        AbstractHandlerMethodMapping handlerMethodMapping = (AbstractHandlerMethodMapping)this.applicationContext.getBean(AbstractHandlerMethodMapping.class);
        for (RequestMappingInfo requestMappingInfo : mappings.keySet()) {
            handlerMethodMapping.unregisterMapping((Object)requestMappingInfo);
        }
    }

    public static void clear(ClassLoader classLoader) {
        Preconditions.checkNotNull((Object)classLoader, (Object)"classLoader is null");
        Introspector.flushCaches();
        ResourceBundle.clearCache(classLoader);
        CachedIntrospectionResults.clearClassLoader((ClassLoader)classLoader);
        LogFactory.release((ClassLoader)classLoader);
    }

    private static void closeQuietly(ConfigurableApplicationContext applicationContext) {
        Preconditions.checkNotNull((Object)applicationContext, (Object)"applicationContext is null");
        try {
            applicationContext.close();
        }
        catch (Exception e) {
            LOGGER.error("Failed to close application context", (Throwable)e);
        }
    }

    @Override
    public ClassLoader getChildClassLoader() {
        return this.applicationContext.getClassLoader();
    }

    @Override
    public PluginConfig getPluginConfig() {
        return this.pluginConfig;
    }
}

