/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.dpl.hotswap;

import com.bxm.warcar.dpl.hotswap.PluginClassLoader2;
import java.io.IOException;
import java.io.InputStream;
import java.net.FileNameMap;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

public class PlugInResourceHandler
extends URLStreamHandler {
    private static final String DEFAULT_PROTOCOL = "pluginresource:";
    private static final String DEFAULT_CONTENT_TYPE = "text/plain";
    private PluginClassLoader2 plugInClassLoader;

    public PlugInResourceHandler(PluginClassLoader2 plugInClassLoader) {
        this.plugInClassLoader = plugInClassLoader;
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        String p = url.getProtocol();
        if (!this.isValid(p)) {
            throw new RuntimeException("invalid protocol,expect " + PlugInResourceHandler.getProtocol() + ",but " + p);
        }
        final String resource = url.getPath();
        return new URLConnection(url){

            @Override
            public void connect() {
            }

            @Override
            public String getContentType() {
                FileNameMap fileNameMap = URLConnection.getFileNameMap();
                String contentType = fileNameMap.getContentTypeFor(resource);
                if (contentType == null) {
                    contentType = PlugInResourceHandler.DEFAULT_CONTENT_TYPE;
                }
                return contentType;
            }

            @Override
            public InputStream getInputStream() throws IOException {
                InputStream is = PlugInResourceHandler.this.plugInClassLoader.getByteStream(resource);
                if (is == null) {
                    throw new IOException("plugInClassLoader.getByteStream() returned null for " + resource);
                }
                return is;
            }
        };
    }

    protected static String getProtocol() {
        return DEFAULT_PROTOCOL;
    }

    private boolean isValid(String p) {
        return p.equals(PlugInResourceHandler.getProtocol().substring(0, PlugInResourceHandler.getProtocol().length() - 1));
    }
}

