/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.dpl.impl;

import com.bxm.warcar.dpl.Plugin;
import com.bxm.warcar.dpl.PluginManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author allen
 * @since 1.0.0
 */
public class PluginManagerImpl implements PluginManager, DisposableBean {

    private static final Logger LOGGER = LoggerFactory.getLogger(PluginManagerImpl.class);
    /**
     * 运行时模块,模块名:模块对象
     */
    private final ConcurrentHashMap<String, Plugin> plugins = new ConcurrentHashMap<String, Plugin>();

    /**
     * 加载模块错误信息
     */
    private final ConcurrentHashMap<String, String> errorContext = new ConcurrentHashMap<String, String>();

    @Override
    public Plugin find(String name) {
        Preconditions.checkArgument(StringUtils.isNotBlank(name), "plugin name is null");
        return plugins.get(name);
    }

    @Override
    public List<Plugin> getPlugins() {
        return ImmutableList.copyOf(plugins.values());
    }

    @Override
    public Plugin register(Plugin plugin) {
        Preconditions.checkNotNull(plugin);
        return plugins.put(plugin.getName(), plugin);
    }

    @Override
    public Plugin remove(String name) {
        Preconditions.checkArgument(StringUtils.isNotBlank(name), "plugin name is null");
        return plugins.remove(name);
    }

    @Override
    public Map<String, String> getErrorPluginContext() {
        return errorContext;
    }

    @Override
    public void destroy() throws Exception {
        Collection<Plugin> plugins = this.plugins.values();
        for (Plugin plugin : plugins) {
            try {
                plugin.destroy();
            } catch (Exception e) {
                LOGGER.error("Failed to destroy plugin: " + plugin.getName(), e);
            }
        }
        plugins.clear();
    }
}
