/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.http;

import com.bxm.warcar.utils.http.HttpPool;
import com.bxm.warcar.utils.http.properties.HttpProperties;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="/http")
@SpringBootApplication
public class HttpTestApplication {
    private static final Logger log = LoggerFactory.getLogger(HttpTestApplication.class);
    @Autowired
    private HttpPool httpClientPool;
    @Autowired
    @Qualifier(value="okHttpPool")
    private HttpPool okHttpPool;
    @Autowired
    @Qualifier(value="restTemplatePool")
    private HttpPool restTemplatePool;

    public static void main(String[] args) {
        SpringApplication.run(HttpTestApplication.class, (String[])args);
    }

    @GetMapping(value={"/test1"})
    public String get(String url, String h) throws IOException {
        HashMap headers = Maps.newHashMap();
        headers.put(h, h);
        log.info(this.httpClientPool.get(url, (Map)headers));
        log.info(this.okHttpPool.get(url, (Map)headers));
        log.info(this.restTemplatePool.get(url, (Map)headers));
        return "ok";
    }

    @PostMapping(value={"/test3"})
    public String postHeader(String url, String p, String i, String h) throws IOException {
        HashMap params = Maps.newHashMap();
        params.put(p, p);
        params.put(i, i);
        HashMap headers = Maps.newHashMap();
        headers.put(h, h);
        log.info(this.httpClientPool.post(url, (Map)params, (Map)headers));
        log.info(this.okHttpPool.post(url, (Map)params, (Map)headers));
        log.info(this.restTemplatePool.post(url, (Map)params, (Map)headers));
        return "ok";
    }

    @PostMapping(value={"/test4"})
    public String postHeader(@RequestBody HttpProperties properties) throws IOException {
        HashMap headers = Maps.newHashMap();
        headers.put("h", "h");
        String url = "http://127.0.0.1:8081/postRequestBody";
        log.info(this.httpClientPool.postRequestBody(url, (Object)properties, (Map)headers));
        log.info(this.okHttpPool.postRequestBody(url, (Object)properties, (Map)headers));
        log.info(this.restTemplatePool.postRequestBody(url, (Object)properties, (Map)headers));
        return "ok";
    }
}

