package com.bxm.warcar.http;

import com.bxm.warcar.utils.http.HttpPool;
import com.bxm.warcar.utils.http.properties.HttpProperties;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.util.HashMap;

/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/3/18 16:26
 */
@Slf4j
@RestController("/http")
@SpringBootApplication
public class HttpTestApplication {
    public static void main(String[] args) {
        SpringApplication.run(HttpTestApplication.class,args);
    }
    @Autowired
    //@Qualifier("httpClientPool")
    private HttpPool httpClientPool;

    @Autowired
    @Qualifier("okHttpPool")
    private HttpPool okHttpPool;

    @Autowired
    @Qualifier("restTemplatePool")
    private HttpPool restTemplatePool;


    @GetMapping("/test1")
    public String get(String url,String h) throws IOException {
        final HashMap<String, String> headers = Maps.newHashMap();
        headers.put(h,h);
        log.info(httpClientPool.get(url,headers));
        log.info(okHttpPool.get(url,headers));
        log.info(restTemplatePool.get(url,headers));
        return "ok";
    }

    @PostMapping("/test3")
    public String postHeader(String url,String p,String i,String h) throws IOException {
        final HashMap<String, Object> params = Maps.newHashMap();
        params.put(p,p);
        params.put(i,i);
        final HashMap<String, String> headers = Maps.newHashMap();
        headers.put(h,h);
        log.info(httpClientPool.post(url,params,headers));
        log.info(okHttpPool.post(url,params,headers));
        log.info(restTemplatePool.post(url,params,headers));
        return "ok";
    }

    @PostMapping("/test4")
    public String postHeader(@RequestBody HttpProperties properties) throws IOException {

        final HashMap<String, String> headers = Maps.newHashMap();
        headers.put("h","h");
        String url = "http://127.0.0.1:8081/postRequestBody";
        log.info(httpClientPool.postRequestBody(url,properties,headers));
        log.info(okHttpPool.postRequestBody(url,properties,headers));
        log.info(restTemplatePool.postRequestBody(url,properties,headers));
        return "ok";
    }


}
