/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.id.redis;

import com.bxm.warcar.id.IdGenerator;
import com.google.common.base.Preconditions;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisIdGenerator
implements IdGenerator {
    private static final int DEFAULT_LEN = 32;
    private static final String DEFAULT_KEY = "com.bxm.warcar.id";
    private int len;
    private final String key;
    private final String prefix;
    private final JedisPool jedisPool;

    public RedisIdGenerator(JedisPool jedisPool) {
        this(DEFAULT_KEY, null, jedisPool);
    }

    public RedisIdGenerator(String prefix, JedisPool jedisPool) {
        this(32, DEFAULT_KEY, prefix, jedisPool);
    }

    public RedisIdGenerator(String key, String prefix, JedisPool jedisPool) {
        this(32, key, prefix, jedisPool);
    }

    public RedisIdGenerator(int len, String key, String prefix, JedisPool jedisPool) {
        Preconditions.checkArgument((len > 20 ? 1 : 0) != 0, (Object)"id length must be > 20");
        this.len = len;
        this.key = key;
        this.prefix = prefix;
        this.jedisPool = jedisPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String next() {
        Jedis jedis = this.jedisPool.getResource();
        try {
            Long value = jedis.incr(this.key);
            String mid = this.getDateTime();
            int midLen = StringUtils.length((String)mid) + StringUtils.length((String)this.prefix);
            int i = this.len - midLen;
            String string = StringUtils.defaultIfBlank((String)this.prefix, (String)"") + mid + StringUtils.leftPad((String)StringUtils.right((String)String.valueOf(value), (int)i), (int)i, (char)'0');
            return string;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    private String getDateTime() {
        Calendar calendar = Calendar.getInstance();
        return StringUtils.join((Object[])new Object[]{calendar.get(1), StringUtils.leftPad((String)String.valueOf(calendar.get(2) + 1), (int)2, (char)'0'), StringUtils.leftPad((String)String.valueOf(calendar.get(5)), (int)2, (char)'0'), StringUtils.leftPad((String)String.valueOf(calendar.get(11)), (int)2, (char)'0'), StringUtils.leftPad((String)String.valueOf(calendar.get(12)), (int)2, (char)'0'), StringUtils.leftPad((String)String.valueOf(calendar.get(13)), (int)2, (char)'0'), StringUtils.leftPad((String)String.valueOf(calendar.get(14)), (int)3, (char)'0')});
    }

    public static void main(String[] args) {
        System.out.println(Long.MAX_VALUE);
        JedisPool jedisPool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), "10.10.1.45", 36379, 2000, "9Db85097a289645E");
        RedisIdGenerator generator = new RedisIdGenerator(32, "com.bxm.warcar.id.guide", "lti.", jedisPool);
        long start = System.currentTimeMillis();
        for (int i = 0; i < 100; ++i) {
            System.out.println(generator.next());
        }
        System.out.println(System.currentTimeMillis() - start);
        start = System.currentTimeMillis();
        System.out.println(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS")));
        System.out.println(System.currentTimeMillis() - start);
        start = System.currentTimeMillis();
        Calendar calendar = Calendar.getInstance();
        String mid = StringUtils.join((Object[])new Object[]{calendar.get(1), StringUtils.leftPad((String)String.valueOf(calendar.get(2) + 1), (int)2, (char)'0'), StringUtils.leftPad((String)String.valueOf(calendar.get(5)), (int)2, (char)'0'), calendar.get(11), calendar.get(12), calendar.get(13), StringUtils.leftPad((String)String.valueOf(calendar.get(14)), (int)3, (char)'0')});
        System.out.println(mid);
        System.out.println(System.currentTimeMillis() - start);
    }
}

