/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.id.redis;

import com.bxm.warcar.id.IdGenerator;
import com.bxm.warcar.id.redis.Prefix;
import java.util.Objects;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class RedisAlphanumericIdGenerator
implements IdGenerator {
    private static final Logger log = LoggerFactory.getLogger(RedisAlphanumericIdGenerator.class);
    private static final String DEFAULT_HASH_KEY = "com.bxm.warcar.alphanumericid";
    private static final int DEFAULT_MAX_LENGTH = 10;
    private static final String DEFAULT_FIELD_INDEX = "index";
    private static final String DEFAULT_FIELD_ID = "id";
    private final JedisPool jedisPool;
    private final String pk;
    private final String hashKey;
    private final int reset;
    private final int maxLength;

    public RedisAlphanumericIdGenerator(JedisPool jedisPool) {
        this(jedisPool, "");
    }

    public RedisAlphanumericIdGenerator(JedisPool jedisPool, String pk) {
        this(jedisPool, pk, DEFAULT_HASH_KEY, 10);
    }

    public RedisAlphanumericIdGenerator(JedisPool jedisPool, String pk, String hashKey, int maxLength) {
        this.jedisPool = jedisPool;
        this.pk = Objects.isNull(pk) ? "" : pk;
        this.hashKey = hashKey;
        this.maxLength = maxLength;
        this.reset = this.computeResetValue(this.pk, maxLength);
        log.info("The reset value is {}", (Object)this.reset);
    }

    private int computeResetValue(String pk, int maxLength) {
        int pklen = pk.length();
        int idLen = maxLength - pklen - Prefix.getMaxLen();
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < idLen; ++i) {
            s.append('9');
        }
        return NumberUtils.toInt((String)s.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String next() {
        try (Jedis jedis = this.jedisPool.getResource();){
            long index = 0L;
            String cacheIndex = jedis.hget(this.hashKey, DEFAULT_FIELD_INDEX);
            if (StringUtils.isBlank((String)cacheIndex)) {
                jedis.hset(this.hashKey, DEFAULT_FIELD_INDEX, Objects.toString(index));
            } else {
                index = NumberUtils.toLong((String)cacheIndex);
            }
            long after = jedis.hincrBy(this.hashKey, "id:" + index, 1L);
            if (after > (long)this.reset) {
                jedis.hset(this.hashKey, DEFAULT_FIELD_INDEX, Objects.toString(++index));
                after = jedis.hincrBy(this.hashKey, "id:" + index, 1L);
            }
            String prefix = Prefix.VALUES[(int)index];
            int idSize = this.maxLength - this.pk.length() - prefix.length();
            String string = this.pk + prefix + StringUtils.leftPad((String)Objects.toString(after), (int)idSize, (char)'0');
            return string;
        }
        catch (Exception e) {
            return RandomStringUtils.randomAlphanumeric((int)this.maxLength);
        }
    }
}

