package com.bxm.warcar.integration.pushable;

import com.bxm.warcar.integration.message.annotation.Messaging;
import com.bxm.warcar.integration.message.annotation.MessagingRequest;
import com.bxm.warcar.integration.message.annotation.MessagingTopicField;
import com.bxm.warcar.integration.pushable.message.MessageEntity;
import org.apache.commons.lang.StringUtils;

/**
 * @author allen
 * @since 1.0.0
 */
public class CachePushableServiceImpl implements CachePushableService {

    @Override
    @Messaging(topicFieldNameOfConfiguration = "cachePush")
    public String push(MessageEntity entity) throws CachePushException {
        return push0(entity);
    }

    @Override
    @Messaging
    public String push(@MessagingRequest MessageEntity entity, @MessagingTopicField String topic) throws CachePushException {
        if (StringUtils.isBlank(topic)) {
            throw new CachePushException("topic cannot be blank!");
        }
        return push0(entity);
    }

    private String push0(MessageEntity entity) throws CachePushException {
        if (null == entity) {
            throw new CachePushException("entity cannot be null");
        }
        String serviceName = entity.getServiceName();
        if (StringUtils.isBlank(serviceName)) {
            throw new CachePushException("'serviceName' cannot be blank");
        }
        return "Service [" + serviceName + "] cached will be start refresh.";
    }
}
