package com.bxm.warcar.integration.distributed.delayed;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;

/**
 * 带延迟时间的任务
 *
 * @author Allen Hu
 * @date 2025/9/11
 */
public class DelayedTask<V extends Serializable> {

    private V value;
    private Long executeTimeInMillis;

    public DelayedTask() {
    }

    /**
     * @param value 任务值
     * @param executeTime 任务执行时间
     */
    public DelayedTask(V value, LocalDateTime executeTime) {
        this(value, executeTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
    }

    /**
     * @param value 任务值
     * @param executeTimeInMillis 任务执行时间，单位：毫秒
     */
    public DelayedTask(V value, Long executeTimeInMillis) {
        this.value = value;
        this.executeTimeInMillis = executeTimeInMillis;
    }

    public V getValue() {
        return value;
    }

    public Long getExecuteTimeInMillis() {
        return executeTimeInMillis;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
