package com.bxm.warcar.integration.distributed.delayed;

import org.redisson.api.RedissonClient;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

/**
 * @author Allen Hu
 * @date 2025/10/22
 */
public class LatestOnlyDelayedTaskQueueToolHolder<T extends Serializable> implements Closeable {

    private final Map<String, LatestOnlyDelayedTaskQueueTool<T>> latestOnlyDelayedTaskQueueToolMap = new ConcurrentHashMap<>();
    private final RedissonClient redissonClient;

    public LatestOnlyDelayedTaskQueueToolHolder(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }

    public LatestOnlyDelayedTaskQueueTool<T> register(String taskName, Class<T> clazz, DelayedTaskExecutor<T> executor, Function<T, Long> latestExecuteTimeProvider) {
        return latestOnlyDelayedTaskQueueToolMap.computeIfAbsent(taskName, k -> {
            LatestOnlyDelayedTaskQueueTool<T> queueTool = new LatestOnlyDelayedTaskQueueTool<>(redissonClient, taskName, clazz, executor, latestExecuteTimeProvider);
            queueTool.init();
            return queueTool;
        });
    }

    public LatestOnlyDelayedTaskQueueTool<T> get(String taskName) {
        return latestOnlyDelayedTaskQueueToolMap.get(taskName);
    }

    @Override
    public void close() throws IOException {
        latestOnlyDelayedTaskQueueToolMap.values().forEach(LatestOnlyDelayedTaskQueueTool::destroy);
    }
}
