package com.bxm.warcar.integration.distributed.scheduler;

import com.bxm.warcar.integration.distributed.DistributedLock;

public interface LockScheduler extends Scheduler {

    /**
     * 分布式锁
     * @return 分布式锁，如果为null，则不使用分布式锁
     * @see com.bxm.warcar.integration.distributed.lock.ZooKeeperDistributedLock
     * @see com.bxm.warcar.integration.distributed.lock.RedissonDistributedLock
     */
    DistributedLock distributedLock();

    /**
     * <p>空闲时间</p>
     *
     * 防止任务执行时间过短，其他实例还没开始获取锁，就已经执行完了。这可能会导致其他实例获取到锁后，又执行了任务。
     *
     * @return 空闲时间，单位：毫秒，一般建议空闲1秒钟。如果明确任务执行时间较长，建议设置为0。
     */
    default long idleTime() {
        return 0;
    }
}
