package com.bxm.warcar.integration.distributed;

import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;

import java.time.Duration;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;

/**
 * 首次执行器
 * <p>
 * 在给定的静默时间内，确保一个操作只被执行一次。这在分布式环境中非常有用，可以防止在短时间内重复处理相同的任务。
 * 例如，当多个服务实例同时收到相同的事件时，只有一个实例能够成功执行关联的操作。
 *
 * @param <T> 执行器接受的参数类型
 * @author Allen Hu
 * @date 2025/10/15
 * @see MultiTimeExecutor
 */
public class FirstTimeExecutor<T> extends MultiTimeExecutor<T> {

    public FirstTimeExecutor(Counter counter, String executorName, Duration silentTime) {
        super(counter, executorName, silentTime, 1);
    }

    public FirstTimeExecutor(Counter counter, String executorName, Duration silentTime, Consumer<T> executor) {
        super(counter, executorName, silentTime, 1, executor);
    }
}
