/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.eventbus;

import com.bxm.warcar.integration.eventbus.AbstractEventPark;
import com.bxm.warcar.integration.eventbus.core.AsyncEventBus;
import com.bxm.warcar.integration.eventbus.core.EventBus;
import com.bxm.warcar.utils.NamedThreadFactory;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public final class AsyncEventPark
extends AbstractEventPark
implements DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncEventPark.class);
    private static final int DEFAULT_AWAIT_TERMINATION_SECONDS = 30;
    private final AsyncEventBus asyncEventBus;
    private final ThreadPoolExecutor threadPoolExecutor;
    private final int awaitTerminationSeconds;

    public AsyncEventPark() {
        this(Runtime.getRuntime().availableProcessors() * 2 + 1, 30);
    }

    public AsyncEventPark(int coreSize) {
        this(coreSize, 30);
    }

    public AsyncEventPark(int coreSize, int awaitTerminationSeconds) {
        this(new ThreadPoolExecutor(coreSize, coreSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("event-park")), awaitTerminationSeconds);
    }

    public AsyncEventPark(ThreadPoolExecutor executor) {
        this(executor, 30);
    }

    public AsyncEventPark(ThreadPoolExecutor executor, int awaitTerminationSeconds) {
        this.threadPoolExecutor = executor;
        this.asyncEventBus = new AsyncEventBus("async-event-bus", executor);
        this.awaitTerminationSeconds = awaitTerminationSeconds;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("ThreadPoolExecutor current core pool size is {}", (Object)executor.getCorePoolSize());
        }
    }

    @Override
    protected EventBus getEventBus() {
        return this.asyncEventBus;
    }

    @Override
    protected String getEventParkName() {
        return "AsyncEventPark";
    }

    public int getCorePoolSize() {
        return this.threadPoolExecutor.getCorePoolSize();
    }

    public int getActiveCount() {
        return this.threadPoolExecutor.getActiveCount();
    }

    public int getQueueSize() {
        return this.threadPoolExecutor.getQueue().size();
    }

    public void destroy() throws Exception {
        this.threadPoolExecutor.shutdown();
        if (!this.threadPoolExecutor.awaitTermination(this.awaitTerminationSeconds, TimeUnit.SECONDS)) {
            LOGGER.warn("ThreadPoolExecutor {} terminated fail", (Object)this.threadPoolExecutor);
        } else if (LOGGER.isInfoEnabled()) {
            LOGGER.info("ThreadPoolExecutor {} terminated success", (Object)this.threadPoolExecutor);
        }
    }
}

