/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.ip.impl;

import com.bxm.warcar.ip.IP;
import com.bxm.warcar.ip.IpLibrary;
import com.bxm.warcar.utils.LifeCycle;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ipplus360IpLibrary
extends LifeCycle
implements IpLibrary {
    private static final Logger LOGGER = LoggerFactory.getLogger(Ipplus360IpLibrary.class);
    private byte[] bytes = null;
    private File file;
    private long base_len = 64L;
    private long offset_addr = 0L;
    private long offset_owner = 0L;
    private byte[] offset_infe;
    private Pattern ip_re = Pattern.compile("^((25[0-5]|2[0-4]\\d|[01]?\\d\\d?)\\.){3}(25[0-5]|2[0-4]\\d|[01]?\\d\\d?)$");
    private ReentrantLock lock = new ReentrantLock();
    private static final String[] SPECIAL_PROVINCIES = new String[]{"\u5317\u4eac\u5e02", "\u5929\u6d25\u5e02", "\u4e0a\u6d77\u5e02", "\u91cd\u5e86\u5e02"};

    public Ipplus360IpLibrary(File file) {
        Preconditions.checkNotNull((Object)file);
        this.file = file;
    }

    protected void doInit() {
        this.refresh();
    }

    protected void doDestroy() {
    }

    @Override
    public IP find(String ip) {
        String str = this.findIp(ip);
        if (StringUtils.isBlank((String)str)) {
            return null;
        }
        String[] array = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)str, (String)"|");
        if (array.length >= 11) {
            String province = this.adjustProvince(array[6]);
            String city = StringUtils.removeEnd((String)array[7], (String)"\u5e02");
            return new IP(array[5], province, city, array[8], null, array[10], array[9], null, null, array[4], "-1", array[3]);
        }
        return null;
    }

    private String adjustProvince(String province) {
        if (ArrayUtils.contains((Object[])SPECIAL_PROVINCIES, (Object)province)) {
            return StringUtils.removeEnd((String)province, (String)"\u5e02");
        }
        return StringUtils.removeEnd((String)province, (String)"\u7701");
    }

    @Override
    public void refresh() {
        long start = System.currentTimeMillis();
        this.load();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Ip library (ipplus360) load finished in {} ms", (Object)(System.currentTimeMillis() - start));
        }
    }

    private void load() {
        this.lock.tryLock();
        try {
            this.bytes = Ipplus360IpLibrary.fileTobyte(this.file);
            byte[] asse = new byte[this.bytes.length - 16];
            byte[] asse1 = new byte[8];
            byte[] asse2 = new byte[8];
            System.arraycopy(this.bytes, 16, asse, 0, this.bytes.length - 16);
            System.arraycopy(this.bytes, 0, asse1, 0, 8);
            System.arraycopy(this.bytes, 8, asse2, 0, 8);
            this.offset_addr = Ipplus360IpLibrary.bytesToLong(asse1);
            this.offset_owner = Ipplus360IpLibrary.bytesToLong(asse2);
            this.offset_infe = asse;
        }
        catch (Exception e) {
            throw new RuntimeException("load", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private long ipToLong(String ipAddress) {
        long result = 0L;
        String[] ipAddressInArray = ipAddress.split("\\.");
        for (int i = 3; i >= 0; --i) {
            long ip = Long.parseLong(ipAddressInArray[3 - i]);
            result |= ip << i * 8;
        }
        return result;
    }

    private static String bytetoChar(byte[] bytes, Integer src, Integer dst) {
        byte[] asses = new byte[dst.intValue()];
        System.arraycopy(bytes, src, asses, 0, dst);
        return new String(asses);
    }

    private static Integer bytetoInt(byte[] bytes, Integer src, Integer dst) {
        byte[] asses = new byte[dst.intValue()];
        System.arraycopy(bytes, src, asses, 0, dst);
        return Ipplus360IpLibrary.byteArrayToInt(asses);
    }

    private static long byteArrayToInt2(byte[] b) {
        long num = 0L;
        for (int ix = 3; ix >= 0; --ix) {
            num <<= 8;
            num |= (long)(b[ix] & 0xFF);
        }
        return num;
    }

    private static long bytetoInt2(byte[] bytes, Integer src, Integer dst) {
        byte[] asses = new byte[4];
        System.arraycopy(bytes, src, asses, 0, 4);
        return Ipplus360IpLibrary.byteArrayToInt2(asses);
    }

    public String findIp(String ip) {
        Matcher m = this.ip_re.matcher(ip);
        if (!m.find()) {
            return "Error IP";
        }
        Long nip = this.ipToLong(m.group(0));
        long record_min = 0L;
        long record_max = this.offset_addr / this.base_len - 1L;
        long record_mid = (record_min + record_max) / 2L;
        while (record_max - record_min >= 0L) {
            long mult_re_ba_l = record_mid * this.base_len;
            Integer mult_re_ba = (int)mult_re_ba_l;
            Long minip = Ipplus360IpLibrary.bytetoInt2(this.offset_infe, mult_re_ba, 4);
            Long maxip = Ipplus360IpLibrary.bytetoInt2(this.offset_infe, mult_re_ba + 4, 4);
            if (nip < minip) {
                record_max = record_mid - 1L;
            } else {
                if (nip.equals(minip) | nip > minip & nip < maxip | nip.equals(maxip)) {
                    Integer addr_begin = Ipplus360IpLibrary.bytetoInt(this.offset_infe, mult_re_ba + 8, 8);
                    Integer addr_length = Ipplus360IpLibrary.bytetoInt(this.offset_infe, mult_re_ba + 16, 8);
                    Integer owner_begin = Ipplus360IpLibrary.bytetoInt(this.offset_infe, mult_re_ba + 24, 8);
                    Integer owner_length = Ipplus360IpLibrary.bytetoInt(this.offset_infe, mult_re_ba + 32, 8);
                    String wgs_lon = Ipplus360IpLibrary.bytetoChar(this.offset_infe, mult_re_ba + 40, 12).trim();
                    String wgs_lat = Ipplus360IpLibrary.bytetoChar(this.offset_infe, mult_re_ba + 52, 12).trim();
                    String addr_bundle = Ipplus360IpLibrary.bytetoChar(this.offset_infe, addr_begin, addr_length).trim();
                    String owner = Ipplus360IpLibrary.bytetoChar(this.offset_infe, owner_begin, owner_length).trim();
                    return minip.toString() + "|" + maxip.toString() + "|" + addr_bundle + "|" + wgs_lon + "|" + wgs_lat + "|" + owner;
                }
                if (nip > maxip) {
                    record_min = record_mid + 1L;
                } else {
                    return "ERROR Case";
                }
            }
            record_mid = (record_min + record_max) / 2L;
        }
        return "Not Found.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] fileTobyte(File file) throws IOException {
        byte[] byArray;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            byte[] data = new byte[in.available()];
            in.read(data);
            in.close();
            byArray = data;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        return byArray;
    }

    private static int byteArrayToInt(byte[] b) {
        return b[0] & 0xFF | (b[1] & 0xFF) << 8 | (b[2] & 0xFF) << 16 | (b[3] & 0xFF) << 24;
    }

    private static long bytesToLong(byte[] b) {
        return (long)b[7] << 56 | ((long)b[6] & 0xFFL) << 48 | ((long)b[5] & 0xFFL) << 40 | ((long)b[4] & 0xFFL) << 32 | ((long)b[3] & 0xFFL) << 24 | ((long)b[2] & 0xFFL) << 16 | ((long)b[1] & 0xFFL) << 8 | (long)b[0] & 0xFFL;
    }

    public static void main(String[] args) throws IOException {
        String fileName = "E:\\\u57c3\u6587\u79d1\u6280\\IP_trial_2018M11_single_WGS84_dat\\IP_trial_2018M11_single_WGS84.dat";
        byte[] bytes = FileUtils.readFileToByteArray((File)new File(fileName));
        String fingerprint = DigestUtils.md5Hex((byte[])bytes);
        System.out.println(fingerprint);
        Ipplus360IpLibrary library = new Ipplus360IpLibrary(new File(fileName));
        library.init();
        System.out.println(library.find("117.136.79.102"));
        System.out.println(library.find("112.17.87.139"));
        System.out.println(library.find("73.32.192.246"));
        System.out.println(library.find("220.176.34.17"));
        System.out.println(library.find("220.191.32.0"));
    }
}

