package com.bxm.warcar.ip.impl;

import com.bxm.warcar.ip.IP;
import com.bxm.warcar.ip.IpLibrary;
import com.bxm.warcar.utils.LifeCycle;
import com.google.common.base.Preconditions;
import net.ipip.ipdb.City;
import net.ipip.ipdb.CityInfo;
import net.ipip.ipdb.IPFormatException;
import net.ipip.ipdb.InvalidDatabaseException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;

/**
 * IPDB 版ipip库
 * @author allen
 * @date 2019/5/15
 * @since 2.0.0
 */
public class IpipNetForDbIpLibrary extends LifeCycle implements IpLibrary {

    private static final Logger LOGGER = LoggerFactory.getLogger(IpipNetForDbIpLibrary.class);
    private City city = null;
    private final String filePath;

    public IpipNetForDbIpLibrary(String filePath) {
        Preconditions.checkArgument(StringUtils.isNotBlank(filePath));
        this.filePath = filePath;
    }

    @Override
    public int getOrder() {
        return 1;
    }

    @Override
    protected void doInit() {
        this.refresh();
    }

    @Override
    protected void doDestroy() {

    }

    @Override
    public IP find(String ip) {
        try {
            CityInfo info = city.findInfo(ip, "CN");
            if (null != info) {
                IP res = new IP();
                res.setCounty(info.getCountryName());
                res.setProvince(info.getRegionName());
                res.setCity(info.getCityName());
                res.setIsp(info.getIspDomain());
                res.setLongitude(info.getLongitude());
                res.setLatitude(info.getLatitude());
                res.setTimezone(info.getTimezone());
                res.setUtczone(info.getUtcOffset());
                res.setTelphonenum(info.getIddCode());
                res.setHitcode(info.getChinaAdminCode());
                res.setCountrycode(info.getCountryCode());
                return res;
            }
        } catch (IPFormatException | InvalidDatabaseException e) {
            LOGGER.warn("findIp: {}", ip);
        }
        return null;
    }

    @Override
    public synchronized void refresh() {
        try {
            long start = System.currentTimeMillis();
            this.city = new City(filePath);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Ip library (ipip) load finished in {} ms", (System.currentTimeMillis() - start));
            }
        } catch (IOException e) {
            throw new RuntimeException("refresh: ", e);
        }
    }
}
