package com.bxm.warcar.ip.impl.aliyun;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;

/**
 *
 * 参考文件：aliyun-ip-profile.json / aliyun-ip-download.json
 *
 * @author allen
 * @date 2022-04-18
 * @since 1.0
 */
public class OssDataServerImpl implements DataServer {

    private final String dataInfoUrl;
    private final String downloadUrl;

    private final HttpClient httpClient;

    public OssDataServerImpl(String dataInfoUrl, String downloadUrl) {
        this.dataInfoUrl = dataInfoUrl;
        this.downloadUrl = downloadUrl;
        this.httpClient = HttpClientBuilder.create().build();
    }

    @Override
    public Map<Type, DataInfo> getDataInfos() throws Exception {
        HttpResponse response = httpClient.execute(new HttpGet(dataInfoUrl));
        String body = EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
        JSONObject jsonObject = JSONObject.parseObject(body);
        Map<Type, DataInfo> res = Maps.newHashMap();
        Set<String> keySet = jsonObject.keySet();
        for (String key : keySet) {
            Type type = Type.valueOf(key);
            DataInfo value = jsonObject.getObject(key, DataInfo.class);
            res.put(type, value);
        }
        return res;
    }

    @Override
    public String getUrl(Type type) throws Exception {
        HttpResponse response = httpClient.execute(new HttpGet(downloadUrl));
        String body = EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
        JSONObject jsonObject = JSONObject.parseObject(body);
        return jsonObject.getString(type.name());
    }
}
