/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.ip.impl;

import com.bxm.warcar.ip.IP;
import com.bxm.warcar.ip.IpLibrary;
import com.bxm.warcar.utils.LifeCycle;
import com.google.common.base.Preconditions;
import java.io.IOException;
import net.ipip.ipdb.City;
import net.ipip.ipdb.CityInfo;
import net.ipip.ipdb.IPFormatException;
import net.ipip.ipdb.InvalidDatabaseException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpipNetForDbIpLibrary
extends LifeCycle
implements IpLibrary {
    private static final Logger LOGGER = LoggerFactory.getLogger(IpipNetForDbIpLibrary.class);
    private City city = null;
    private final String filePath;

    public IpipNetForDbIpLibrary(String filePath) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)filePath));
        this.filePath = filePath;
    }

    public int getOrder() {
        return 1;
    }

    protected void doInit() {
        this.refresh();
    }

    protected void doDestroy() {
    }

    @Override
    public IP find(String ip) {
        try {
            CityInfo info = this.city.findInfo(ip, "CN");
            if (null != info) {
                IP res = new IP();
                res.setCounty(info.getCountryName());
                res.setProvince(info.getRegionName());
                res.setCity(info.getCityName());
                res.setIsp(info.getIspDomain());
                res.setLongitude(info.getLongitude());
                res.setLatitude(info.getLatitude());
                res.setTimezone(info.getTimezone());
                res.setUtczone(info.getUtcOffset());
                res.setTelphonenum(info.getIddCode());
                res.setHitcode(info.getChinaAdminCode());
                res.setCountrycode(info.getCountryCode());
                return res;
            }
        }
        catch (IPFormatException | InvalidDatabaseException e) {
            LOGGER.warn("findIp: {}", (Object)ip);
        }
        return null;
    }

    @Override
    public synchronized void refresh() {
        try {
            long start = System.currentTimeMillis();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Ip library (ipip.net) loading...");
            }
            this.city = new City(this.filePath);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Ip library (ipip.net) load finished in {} ms", (Object)(System.currentTimeMillis() - start));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("refresh: ", e);
        }
    }
}

