/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.logging.support;

import com.aliyun.openservices.aliyun.log.producer.Callback;
import com.aliyun.openservices.aliyun.log.producer.LogProducer;
import com.aliyun.openservices.aliyun.log.producer.ProducerConfig;
import com.aliyun.openservices.aliyun.log.producer.ProjectConfig;
import com.aliyun.openservices.aliyun.log.producer.Result;
import com.aliyun.openservices.aliyun.log.producer.errors.ProducerException;
import com.aliyun.openservices.log.common.LogItem;
import com.bxm.warcar.logging.Logging;
import com.bxm.warcar.logging.LoggingWriter;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.TypeHelper;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class AliyunLogServiceLoggingWriter
implements LoggingWriter,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(AliyunLogServiceLoggingWriter.class);
    private final ProducerConfig producerConfig;
    private final ProjectConfig projectConfig;
    private final String logStore;
    private ThreadPoolExecutor executor;
    private LoggingWriter fallback;
    private LogProducer producer;

    public AliyunLogServiceLoggingWriter(ProducerConfig producerConfig, ProjectConfig projectConfig, String logStore) {
        this.producerConfig = producerConfig;
        this.projectConfig = projectConfig;
        this.logStore = logStore;
    }

    @Override
    public void write(final Logging logging) {
        if (Objects.nonNull(this.executor)) {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    AliyunLogServiceLoggingWriter.this.send(logging);
                }
            });
        } else {
            this.send(logging);
        }
    }

    private void send(final Logging logging) {
        String topic = logging.getApplicationId();
        LogItem logItem = new LogItem();
        logItem.PushBack("applicationId", logging.getApplicationId());
        logItem.PushBack("requestedSessionId", logging.getRequestedSessionId());
        logItem.PushBack("scheme", logging.getScheme());
        logItem.PushBack("host", logging.getHost());
        logItem.PushBack("port", TypeHelper.castToString((Object)logging.getPort()));
        logItem.PushBack("method", logging.getMethod());
        logItem.PushBack("path", logging.getPath());
        logItem.PushBack("queryString", logging.getQueryString());
        logItem.PushBack("params", JsonHelper.convert(logging.getParams()));
        logItem.PushBack("clientIp", logging.getClientIp());
        logItem.PushBack("serverIp", logging.getServerIp());
        logItem.PushBack("headers", JsonHelper.convert(logging.getHeaders()));
        logItem.PushBack("startTime", TypeHelper.castToString((Object)logging.getStartTime()));
        logItem.PushBack("endTime", TypeHelper.castToString((Object)logging.getEndTime()));
        logItem.PushBack("requestBody", logging.getRequestBody());
        logItem.PushBack("responseBody", logging.getResponseBody());
        logItem.PushBack("consumeTimeInMillis", TypeHelper.castToString((Object)logging.getConsumeTimeInMillis()));
        logItem.PushBack("success", TypeHelper.castToString((Object)logging.isSuccess()));
        logItem.PushBack("throwable", logging.getThrowable());
        logItem.PushBack("operator", logging.getOperator());
        try {
            this.producer.send(this.projectConfig.getProject(), this.logStore, topic, null, logItem, new Callback(){

                public void onCompletion(Result result) {
                    if (log.isDebugEnabled()) {
                        log.debug("send: {}", (Object)result);
                    }
                    if (!result.isSuccessful() && Objects.nonNull(AliyunLogServiceLoggingWriter.this.fallback)) {
                        AliyunLogServiceLoggingWriter.this.fallback.write(logging);
                    }
                }
            });
        }
        catch (ProducerException | InterruptedException e) {
            log.error("send: ", e);
        }
    }

    public void destroy() throws Exception {
        try {
            this.producer.close();
        }
        catch (ProducerException | InterruptedException e) {
            log.error("close: ", e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.producer = new LogProducer(this.producerConfig);
        this.producer.putProjectConfig(this.projectConfig);
    }

    public void setFallback(LoggingWriter fallback) {
        this.fallback = fallback;
    }

    public void setExecutor(ThreadPoolExecutor executor) {
        this.executor = executor;
    }
}

