/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.message.dingding;

import com.alibaba.fastjson.JSONObject;
import com.bxm.warcar.message.Message;
import com.bxm.warcar.message.MessageSender;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * @author allen
 * @since 1.0.0
 */
public class DingDingMessageSender implements MessageSender {

    private final String url;

    public DingDingMessageSender(String url) {
        this.url = url;
    }

    @Override
    public boolean send(Message message) {
        JSONObject jsonParam = new JSONObject();

        Map<String, Object> text = new HashMap<>();
        text.put("content", message.getContent());

        Map<String, Object> at = new HashMap<>();
        at.put("atMobiles", message.getTos());
        at.put("isAtAll", false);

        jsonParam.put("msgtype", "text");
        jsonParam.put("text", text);
        jsonParam.put("at", at);

        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json; charset=UTF-8");
        HttpEntity<String> req = new HttpEntity<>(jsonParam.toJSONString(), headers);
        RestTemplate rest = new RestTemplate();
        ResponseEntity<SendResult> responseEntity = rest.postForEntity(url, req, SendResult.class);

        SendResult body = responseEntity.getBody();
        return null != body && body.isSucceed();
    }

    public static class SendResult implements Serializable {

        private static final long serialVersionUID = -9083143317071986607L;
        private int errcode = -1;
        private String errmsg;

        public boolean isSucceed() {
            return errcode == 0;
        }

        public int getErrcode() {
            return errcode;
        }

        public void setErrcode(int errcode) {
            this.errcode = errcode;
        }

        public String getErrmsg() {
            return errmsg;
        }

        public void setErrmsg(String errmsg) {
            this.errmsg = errmsg;
        }
    }
}
